<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>CMS</title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Theme style -->
    <link rel="stylesheet" href="{{ asset('stylesheets/all.css') }}">
    <!-- Theme style -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Figtree:ital,wght@0,300..900;1,300..900&display=swap"
          rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('stylesheets/adminlte.min.css') }}">
    <link rel="stylesheet" href="{{ asset('css/tailwind.css') }}">
</head>
<body class="hold-transition login-page">
<div class="login-box">
    <div class="login-logo">
        <a href="#"><b style="font-size: 24px;">Church Management System </b></a>
    </div>
    <!-- /.login-logo -->
    <div class="card tw-rounded-xl">
        <div class="card-body py-5  login-card-body tw-rounded-xl">
            <h4>
                Sign In
            </h4>
            <p class="text-muted tw-text-sm my-3 tw-tracking-wider">Sign in to start your session</p>

            @if( isset($error))
                <p class="alert alert-danger p-1 pl-2">{{$error}}</p>
            @endif


            <form action="{{route('login')}}" method="post" autocomplete="off">
                @csrf
                <div class="form-group">
                    <label for="email" class="font-weight-normal">Email or Code</label>
                    <div class="input-group">
                        <input type="text" name="email" title="Code" class="form-control form-control-lg tw-text-sm" value="{{ old('email') }}"
                               placeholder="Code or Email">

                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-envelope"></span>
                            </div>
                        </div>
                    </div>
                    @error('email')
                    <span class="text-danger">{{$message}}</span>
                    @enderror
                </div>
                <div class="form-group">
                    <label for="password" class="font-weight-normal">Password</label>
                    <div class="input-group">
                        <input type="password" name="password" title="password" class="form-control form-control-lg tw-text-sm"
                               placeholder="Password">

                        <div class="input-group-append">
                            <div class="input-group-text">
                                <span class="fas fa-lock"></span>
                            </div>
                        </div>
                    </div>
                    @error('password')
                    <span class="text-danger">{{$message}}</span>
                    @enderror
                </div>

                <div class="form-group">
                    <div class="custom-control custom-checkbox">
                        <input type="checkbox" class="custom-control-input" id="remember" name="remember">
                        <label class="custom-control-label font-weight-normal" for="remember">
                            Remember Me
                        </label>
                    </div>
                </div>

                <div class="form-group">
                    <button type="submit" class="btn btn-primary btn-block btn-lg small">Sign In</button>
                </div>
            </form>


        </div>
        <!-- /.login-card-body -->
    </div>
</div>
<!-- /.login-box -->


</body>
</html>
