

@extends("master")
@section("title",auth()->user()->company->name??"")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark"> Users</h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Layout</a></li>
                            <li class="breadcrumb-item active">Top Navigation</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                <button class="btn btn-primary float-right btn-sm btn-create">New User</button>
                            </div>
                            <div class="card-body">
                                <table class="table table-striped table-hover data-table">
                                    <thead>
                                    <tr>
                                        <th style="width: 10px">#</th>
                                        <th>Names</th>
                                        <th>Email</th>
                                        <th>Created At</th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($users as $key=>$item)
                                        <tr >
                                            <td>{{++$key}}</td>
                                            <td>{{$item->name}}</td>
                                            <td>{{$item->email}}</td>
                                            <td>
                                                {{$item->created_at}}
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="#"
                                                       data-name="{{$item->name}}"
                                                       data-id="{{$item->id}}"
                                                       data-email="{{$item->email}}"
                                                       data-small="{{$item->small_group_id}}"
                                                       class="btn btn-edit btn-primary"><i class="fa fa-edit"></i></a>
                                                    <a href="{{route('users.permissions.index',$item->id)}}"
                                                       class="btn js-permissions"><i class="fa fa-cog"></i></a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
{{--                            <div class="card-footer clearfix">--}}
{{--                                {{$list->links()}}--}}
{{--                            </div>--}}
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <!-- Control Sidebar -->


    <div class="modal fade" id="modal-default">
        <div class="modal-dialog">
            <form action="{{route("create.user")}}" method="post" id="submitForm">

                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Add new User</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" name="id" value="0" id="user_id">
                        @csrf
                        <div class="form-group">
                            <label for="name">Name</label>
                            <input type="text" class="form-control" id="name" placeholder="Username" name="name" required>
                        </div>
                        <div class="form-group">
                            <label for="email">Email</label>
                            <input type="text" class="form-control" id="email" placeholder="Email" name="email" required>
                        </div>
                        <div class="form-group" id="password-group">
                            <label for="password">Password</label>
                            <input type="password" class="form-control" id="password" placeholder="Password" name="password" required>
                        </div>

                        <div class="form-check">
                            <input name="small_check" type="checkbox" onchange="if(this.checked) $('.member_small_group_div').show();else $('.member_small_group_div').hide();" class="form-check-input" id="small_check">
                            <label class="form-check-label" for="small_check">Small Group Leader</label>
                        </div>
                        <div class="form-group member_small_group_div" style="display: none">
                            <label for="small_group_id">Small Group</label>
                            <select class="form-control" name="small_group_id" id="small_group_id" required>
                                <option value="">-- Select --</option>
                                @foreach($smallGroups as $smallgroup)
                                    <option value="{{$smallgroup->id}}">{{$smallgroup->group_name}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <div class="modal fade" id="exampleModalLongPermissions" data-backdrop="static" tabindex="-1" role="dialog"
         aria-labelledby="staticBackdrop" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <form action="{{route('users.permissions.add.modify')}}" method="post" id="submissionForm">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Permissions</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <i aria-hidden="true" class="ki ki-close"></i>
                        </button>
                    </div>
                    <div class="modal-body">

                    </div>
                    <div class="modal-footer">
                        @include('partial._modal_footer_buttons')
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
    </div>

@endsection


@section("script")
    <script>
        $(function () {
            $('#submitForm').validate();
            $(".btn-create").click(function (e) {
                e.preventDefault();
                $("#modal-default").modal("show");
            });


            $(document).on('click','.btn-edit',function (e) {
                e.preventDefault();
                $("#modal-default").modal("show");
                $('#user_id').val($(this).data('id'));
                $("#email").val($(this).data('email'));
                $("#name").val($(this).data('name'));
                $("#password-group").hide();

                let smId = $(this).data('small');

                $("#small_group_id").val(smId);

                let hasId = smId > 0;

                $("#small_check").prop("checked",hasId).trigger("change");
            });

            $('#modal-default').on('hidden.bs.modal', function (e) {
                $('#user_id').val(0);
                $("#password-group").show();
            });


            $(document).on('click', '.js-permissions', function (e) {
                e.preventDefault();
                var modal =
                    $("#exampleModalLongPermissions");
                modal.modal('show');
                modal.find("button[type=submit").prop("disabled", true);
                modal.find(".modal-body").html("<div class='text-center'><div class=\"spinner spinner-primary spinner-lg d-inline-block\"></div></div>");
                $.ajax({
                    url: this.href,
                    success: function (res) {
                        modal.find(".modal-body").html(res);
                    },
                    error: function () {
                        modal.find(".modal-body").empty();
                    },
                    complete: function () {
                        modal.find("button[type=submit").prop("disabled", false);
                    }
                });
            });
        })
    </script>
@endsection

