@extends('master')
@section('title',"Momo Preview")
@section('body')
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark">
                            MOMO Preview
                        </h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                            <li class="breadcrumb-item active">
                                MOMO Preview
                            </li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card card-primary card-outline">
                            <div class="card-body">

                                <h4>
                                    Data Preview
                                </h4>
                                <p class="text-muted small">
                                    Preview of the MOMO data - {{$groupedData->count()}} records found.
                                </p>

                                <form action="{{ route('tithe-and-offering.tithes-import') }}" method="POST">
                                    @csrf
                                    <table class="table">
                                        <thead>
                                        <tr>
                                            <th>Excel Category</th>
                                            <th>Total Members</th>
                                            <th>Total Amount</th>
                                            <th>Category Mapping</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($groupedData as $data)
                                            <tr>
                                                <td>{{ $data['category'] }}</td>
                                                <td>{{ $data['total_members'] }}</td>
                                                <td>{{ number_format($data['total_amount'], 2) }}</td>
                                                <td>
                                                    <input type="hidden" name="grouped_categories[]"
                                                           value="{{ $data['category'] }}">
                                                    <select name="categories[]" required
                                                            class="form-control">
                                                        <option value="">Select Offering Type</option>
                                                        @foreach($categories as $category)
                                                            <option
                                                                value="{{ $category->id }}">{{ $category->OfferingName }}</option>
                                                        @endforeach
                                                    </select>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>

                                    <button type="submit" class="btn btn-primary">Submit and Save</button>
                                </form>
                            </div>

                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>

@endsection

@section('script')
    <script>
        $('#momoTable').DataTable();
    </script>
@endsection
