@extends('custom_master')
@section('title',"Sales Activity report")
@section('navigation')

@endsection
@section('content')
    <div class="container">
        <x-page-header current-page-title="Offering Report" is-printable="true">
            <li class="breadcrumb-item text-muted">
                <a href="#">
                    Offering
                </a>
            </li>
        </x-page-header>

        <div class="bg-white my-5 p-0">

            <table class="table table-borderless">
                <tbody>
                <tr>
                    {{--                    <td>--}}
                    {{--                        <img src="{{ asset('media/logo.png') }}" class="h-50px" alt="">--}}
                    {{--                    </td>--}}
                    <td>
                        <div>
                            <h3>Church Management System</h3>
                        </div>

                    </td>
                    <td>
                        <div class="text-right">
                            <div>
                                <strong>Printed on : </strong>
                                {{ now()->format('d-M-Y') }}
                            </div>
                            <div>
                                <strong>Start date: {{ request('start-date') }}</strong>
                            </div>
                            <div>
                                <strong>End date: {{ request('end-date') }}</strong>
                            </div>
                        </div>
                    </td>
                </tr>
                </tbody>
            </table>
            <div class="px-3">
                <div>
                    {{--                        <h4 class="mb-0 card-title">Periodical payments</h4>--}}
                    <p class="">
                        <strong>Start Date:</strong>
                        <span>{{ request('start-date')??'N/A' }}</span>,
                        <strong>End Date:</strong>
                        <span>{{ request('end-date')??'N/A' }}</span>
                    </p>
                    {{--                    <p class="mb-0">--}}
                    {{--                        <strong>POS Name:</strong>--}}
                    {{--                        <span>{{ request('pos_name')??'ALL' }}</span>,--}}
                    {{--                        <strong>Invoice Type:</strong>--}}
                    {{--                        <span>{{ request('status')??'ALL' }}</span>--}}
                    {{--                    </p>--}}
                </div>
            </div>
            <div style="border-top: 2px solid black;"
                 class="d-flex align-items-center justify-content-center py-4">
                <h4>Offering Detailed Report</h4>
            </div>
            @php
                $sum=0;
            @endphp
            <table class="table border border-dark table-borderless">
                <thead>
                <tr>
                    <th>Offering Type</th>
                    <th>Names</th>
                    <th>Total amount</th>
                    <th>Date</th>
                </tr>
                </thead>
                <tbody>
                @foreach($data as $item)

                    @php
                            $sum+=$item->Amount??0;
                    @endphp
                    <tr>
                        <td>{{ $item->offering->OfferingName??'N/A' }}</td>
                        <td>{{ $item->member_names??'N/A' }}</td>
                        <td>{{ number_format($item->Amount??0) }}</td>
                        <td>{{ $item->Date??'N/A' }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>

            <div class="float-right mt-2 mb-5 p-4 w-300px text-left font-weight-bolder"
                 style="background-color: #3a3838;color: white;border: 1px solid #3a3838 !important;">
                TOTAL AMOUNT: {{ number_format($sum) }}
            </div>
        </div>
    </div>
@stop
