@extends("master")
@section("title",auth()->user()->name??"")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark"> Tithe And Offering </h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Layout</a></li>
                            <li class="breadcrumb-item active">Top Navigation</li>
                        </ol>

                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                <div class="card-title">
                                    <form action="#" method="get" class="form-inline">
                                        <div class="form-group">
                                            <input type="date" name="start_date" value="{{$start}}" id="start_date"
                                                   title="Start Date" class="form-control"/>
                                        </div>
                                        <div class="form-group ml-2">
                                            <input type="date" name="end_date" value="{{$end}}" id="end_date"
                                                   title="End date" class="form-control"/>
                                        </div>
                                        <button class="btn btn-primary ml-2">Search</button>
                                    </form>
                                </div>
                                <div class="card-toolbar">
                                    <!-- Button trigger modal-->
                                    <div class="btn-group float-right">
                                        <div class="dropdown">
                                            <button class="btn btn-secondary dropdown-toggle" type="button"
                                                    data-toggle="dropdown" aria-expanded="false">
                                                <span class="fa fa-file-excel"></span>
                                                Upload
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item" href="javascript:void(0)" data-toggle="modal"
                                                   data-target="#uploadCFMSModal">CFMS Upload</a>
                                                <a class="dropdown-item" data-toggle="modal"
                                                   data-target="#uploadMomoModal" href="javascript:void(0)">MOMO
                                                    Upload</a>
                                                <a class="dropdown-item" href="javascript:void(0)"
                                                   data-target="#uploadExcelModal" data-toggle="modal">Manual Upload</a>
                                            </div>
                                        </div>

                                        <button type="button" class="btn btn-success btn-sm btn-create float-right"
                                                data-toggle="modal"
                                                data-target="#exampleModalLong">
                                            <span class=""></span>
                                            New Tithe And Offering
                                        </button>
                                    </div>
                                    <!-- Modal-->
                                </div>
                            </div>


                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover datatable" id="datatable">
                                        <thead>
                                        <tr>
                                            <th style="width: 10px">#</th>
                                            {{--                                            <th>Church</th>--}}
                                            <th>Member Names</th>
                                            <th>Member Phone</th>
                                            <th>Offering Type</th>
                                            <th>Amount</th>
                                            <th>Payment Option</th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        {{--                                        @foreach($tithes as $key=>$tithe)--}}

                                        {{--                                            <tr >--}}
                                        {{--                                                <td>{{++$key}}</td>--}}
                                        {{--                                                <td>{{$tithe->company->name??''}}</td>--}}
                                        {{--                                                <td>{{$tithe->member_names??''}}</td>--}}
                                        {{--                                                <td>{{$tithe->member_phone??''}}</td>--}}
                                        {{--                                                <td>{{$tithe->offering->OfferingName??''}}</td>--}}
                                        {{--                                                <td>{{number_format($tithe->Amount)}}</td>--}}
                                        {{--                                                <td>{{$tithe->payment->PaymentOption??''}}</td>--}}
                                        {{--                                                <td>{{$tithe->Date}}</td>--}}
                                        {{--                                                <td>--}}
                                        {{--                                                </td>--}}
                                        {{--                                            </tr>--}}
                                        {{--                                        @endforeach--}}
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="card-footer clearfix">
                                {{--                                                                {{$tithes->links()}}--}}
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>

    <div class="modal fade" id="exampleModalLong" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form action="{{route('tithe.and.offering.store')}}" method="post" id="submissionForm"
                  class="submissionForm" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Add Tithe And Offering</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="MemberId">Member Names</label>
                                    <select style="width: 100%;"
                                            onchange="changeMember(this,'#member_names','#member_phone');" type="text"
                                            name="MemberId" id="MemberId" class="form-control custom-select2">
                                        <option value="">Select Member</option>
                                        @foreach($members as $member)
                                            <option value="{{$member->id}}"
                                                    data-name="{{$member->firstname}} {{$member->lastname}}"
                                                    data-phone="{{$member->phone_number}}">{{$member->firstname}}{{$member->lastname}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="member_names">Member names </label>
                                    <input type="text" id="member_names" name="member_names" class="form-control"
                                           required/>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="member_phone">Member phone </label>
                                    <input type="number" id="member_phone" name="member_phone" class="form-control"/>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="OfferingTypeId">Offering Type</label>
                                    <select type="text" name="OfferingTypeId" id="OfferingTypeId" class="form-control"
                                            required>
                                        <option value="">-- Select Type --</option>
                                        @foreach($types as $offering)
                                            <option value="{{$offering->id}}">{{$offering->OfferingName}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="Amount">Amount </label>
                                    <input type="text" id="Amount" name="Amount" class="form-control"
                                           required/>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="PaymentOptionId">Payment Option </label>
                                    <select type="text" name="PaymentOptionId" id="PaymentOptionId" class="form-control"
                                            required>
                                        <option value="">-- Select --</option>
                                        @foreach($payments as $payment)
                                            <option value="{{$payment->id}}">{{$payment->PaymentOption}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="Date">Date </label>
                                    <input type="date" id="Date" name="Date" class="form-control"
                                           required/>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <div class="modal fade" id="uploadExcelModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form action="{{route('tithe.and.offering.import')}}" method="post" id="uploadForm" class="uploadForm"
                  enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Bulk Upload</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <p class="text-muted">Column Order(Date & time, Names, Phone, Type, Amount) <a
                                    href="{{route('tithe.and.offering.get.template')}}" class="btn btn-link">
                                    <i class="fa fa-download"></i> Template
                                </a></p>
                        </div>
                        <div class="form-group">
                            <label for="file">Choose Excel file</label>
                            <input type="file" class="form-control" id="file" name="file" required>
                        </div>
                        <div class="form-group">
                            <label for="modeId"> Payment Option </label>
                            <select type="text" name="modeId" id="modeId" class="form-control" required>
                                <option value="">-- Select mode ---</option>
                                @foreach($payments as $payment)
                                    <option value="{{$payment->id}}">{{$payment->PaymentOption}}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="modalUpdate" data-backdrop="static" tabindex="-1" role="dialog"
         aria-labelledby="staticBackdrop" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{route('tithe.and.offering.update')}}" method="post" id="submissionFormEdit"
                  class="submissionForm" enctype="multipart/form-data">
                @csrf
                <input type="hidden" value="0" id="TitheId" name="TitheId">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Edit Tithe And Offering</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="edit-member">Member Names</label>
                                    <select type="text"
                                            onchange="changeMember(this,'#edit_member_names','#edit_member_phone');"
                                            style="width: 100%;" name="MemberId" id="edit-member"
                                            class="form-control custom-select2" required>
                                        <option value="">Select Member Names</option>
                                        @foreach($members as $member)
                                            <option value="{{$member->id}}"
                                                    data-name="{{$member->firstname}} {{$member->lastname}}"
                                                    data-phone="{{$member->phone_number}}">{{$member->firstname}} {{$member->lastname}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit_member_names">Member names </label>
                                    <input type="text" id="edit_member_names" name="member_names" class="form-control"/>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit_member_phone">Member phone </label>
                                    <input type="number" id="edit_member_phone" name="member_phone"
                                           class="form-control"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-offering">Offering Type</label>
                                    <select type="text" name="OfferingTypeId" id="edit-offering" class="form-control"
                                            required>
                                        <option value="">Select Offering Type</option>
                                        @foreach($types as $offering)
                                            <option value="{{$offering->id}}">{{$offering->OfferingName}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-amount">Amount </label>
                                    <input type="text" id="edit-amount" name="Amount" class="form-control"
                                           required/>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-payment">Payment Option </label>
                                    <select type="text" name="PaymentOptionId" id="edit-payment" class="form-control"
                                            required>
                                        <option value="">--Select mode --</option>
                                        @foreach($payments as $payment)
                                            <option value="{{$payment->id}}">{{$payment->PaymentOption}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-date">Date </label>
                                    <input type="date" id="edit-date" name="Date" class="form-control"
                                           required/>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
    </div>

    {{--    upload CMFS modal--}}

    <div class="modal fade" id="uploadCFMSModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <form action="{{route('cmfs.import')}}" method="post" id="uploadCFMSForm" class="uploadCFMSForm"
                  enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">CFMS Upload</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="form-group">
                            <label for="offering_type_id">Offering Type</label>
                            <select type="text" name="offering_type_id" id="offering_type_id" class="form-control"
                                    required>
                                <option value="">-- Select Type --</option>
                                @foreach(\App\OfferingType::query()->where('CompanyId','=',auth()->user()->company_id)->get() as $offering)
                                    <option value="{{$offering->id}}">{{$offering->OfferingName}}</option>
                                @endforeach
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="customFile">Choose Excel file</label>
                            <div class="custom-file">
                                <input type="file" name="file" class="custom-file-input" id="customFile"/>
                                <label class="custom-file-label" for="customFile">Choose file</label>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Save Changes</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>

                    </div>
                </div>
            </form>
        </div>
    </div>
    {{--    upload MOMO modal--}}

    <div class="modal fade" id="uploadMomoModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <form action="{{route('tithe-and-offering.momo')}}" method="post" id="uploadMomoForm" class="uploadMomoForm"
                  enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">MOMO File Upload</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">


                        <div class="form-group">
                            <label for="customFile">Choose Excel file</label>
                            <div class="custom-file">
                                <input type="file" name="file" class="custom-file-input" id="customFile"/>
                                <label class="custom-file-label" for="customFile">Choose file</label>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-primary">Preview</button>
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>
            </form>
        </div>
    </div>

@endsection

@section("script")
    <!-- Laravel Javascript Validation -->
    {{--    <script src="https://unpkg.com/sweetalert2@7.18.0/dist/sweetalert2.all.js"></script>--}}
    {{--    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>--}}
    {{--    {!! JsValidator::formRequest('App\Http\Requests\ValidateManufacture', '.submissionForm'); !!}--}}
    <script>


        function changeMember(elem, nm, ph) {
            if ($(elem).val()) {
                $(nm + "," + ph).prop("readonly", true);
            } else {
                $(nm + "," + ph).prop("readonly", false);
            }
            let name = $("option:selected", elem).data('name');
            let phone = $("option:selected", elem).data('phone');
            $(nm).val(name);
            $(ph).val(phone);
        }

        $('.custom-select2').select2()

        $(document).ready(function () {

            $('.datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('tithe.and.offering.create') }}?start_date=" + $("#start_date").val() + "&end_date=" + $("#end_date").val(),
                columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false},
                    {data: 'member_names', name: 'member_names'},
                    {data: 'member_phone', name: 'member_phone'},
                    {data: 'offering.OfferingName', name: 'offering.OfferingName'},
                    {
                        data: 'Amount', name: 'Amount', render: function (data, type, row) {
                            return Number(data).toLocaleString();
                        }
                    },
                    {data: 'payment.PaymentOption', name: 'payment.PaymentOption'},
                    {data: 'Date', name: 'Date'},
                    {data: 'action', name: 'action', searchable: false, orderable: false},
                ]
            }).order([6, 'desc']);


            $("#submissionForm").validate();
            $("#uploadForm").validate();
            $(document).on('click', '.js-edit', function (e) {
                console.log('clicked');
                e.preventDefault();
                $("#modalUpdate").modal('show');
                var url = $(this).data('url');
                $("#TitheId").val($(this).data('id'));
                $("#edit-company").val($(this).data('company'));
                $("#edit-member").val($(this).data('member')).trigger("change");
                $("#edit-offering").val($(this).data('offering'));
                $("#edit-amount").val($(this).data('amount'));
                $("#edit_member_names").val($(this).data('names'));
                $("#edit_member_phone").val($(this).data('phone'));
                $("#edit-payment").val($(this).data('payment'));
                $("#edit-date").val($(this).data('date'));
                $('#submissionFormEdit').attr('action', url);
            });
            $(document).on('click', '.js-delete', function (e) {
                // console.log('deleted');
                e.preventDefault();
                var href = this.href;
                Swal.fire({
                    title: "Are you sure?",
                    text: "Delete this Tithe And Offering ?",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Yes, delete it!",
                    cancelButtonText: "No, cancel!",
                    reverseButtons: true
                }).then((willDelete) => {
                    if (willDelete.value) {
                        window.location = href;
                    } else {
                        //swal("Your imaginary file is safe!");
                    }
                });
            });
        });

        $('#exampleModalLong').on('hidden.bs.modal', function (e) {
            $('#TitheId').val(0);
            $("#edit-member,#MemberId").val("").trigger("change");
        });

    </script>

@endsection

