@extends("master")
@section("title","Tithe and Offering Details")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h4 class="m-0 text-dark"> Tithe And Offering </h4>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                            <li class="breadcrumb-item"><a href="{{ route('base-offering-tithe.index') }}">Tithe and
                                    Offering</a></li>
                            <li class="breadcrumb-item active">
                                Details
                            </li>
                        </ol>

                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                <div class="card-title">
                                    <h5>
                                        Details
                                    </h5>
                                    <p class="text-muted small">
                                        Below are the details of the Tithe and Offering.
                                    </p>
                                </div>
                                <div class="card-toolbar">
                                    <!-- Button trigger modal-->
                                    <div class="d-flex float-right">
                                        @if($titheOfferingBase->status!=\App\AppStatus::APPROVED)
                                            <a href="{{route('base-offering-tithe.destroy',$titheOfferingBase->id)}}"
                                               class="btn btn-danger btn-sm mr-3" id="js-all-delete">
                                                <i class="fa fa-trash"></i>
                                                Delete
                                            </a>

                                        @endif
                                        @if($titheOfferingBase->status==\App\AppStatus::PENDING)
                                            <a href="{{ route('base-offering-tithe.approve',$titheOfferingBase->id) }}"
                                               class="btn btn-success btn-sm" id="btn-approve">
                                                Approve
                                                <i class="fa fa-check-circle"></i>
                                            </a>
                                        @endif

                                        <a href="{{route('offering-and-tithe.export-to-excel',['model_id'=>$titheOfferingBase->id])}}"
                                           target="_blank"
                                           class="btn btn-outline-success btn-sm ml-3">
                                            <i class="fa fa-file-excel"></i>
                                            Export to Excel
                                        </a>

                                    </div>
                                    <!-- Modal-->
                                </div>
                            </div>


                            <div class="card-body">

                                <div class="row">
                                    <div class="col-md-6 col-lg-4">
                                        <div class="form-group">
                                            <label for="company" class="font-weight-bolder">Date:</label>
                                            <div>{{$titheOfferingBase->created_at->format('d-m-Y') }}</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-lg-4">
                                        <div class="form-group">
                                            <label for="company" class="font-weight-bolder">Done By:</label>
                                            <div>{{$titheOfferingBase->user->name }}</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-lg-4">
                                        <div class="form-group">
                                            <label for="company" class="font-weight-bolder">Source:</label>
                                            <div>{{$titheOfferingBase->source }}</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-lg-4">
                                        <div class="form-group">
                                            <label for="company" class="font-weight-bolder">Total Records:</label>
                                            <div>{{number_format($titheOfferingBase->tithe_offerings_count) }}</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-lg-4">
                                        <div class="form-group">
                                            <label for="company" class="font-weight-bolder">Total Amount:</label>
                                            <div>{{number_format($titheOfferingBase->tithe_offerings_sum_amount) }}</div>
                                        </div>
                                    </div>
                                    <div class="col-md-6 col-lg-4">
                                        <div class="form-group">
                                            <label for="company" class="font-weight-bolder">Status:</label>
                                            <div>
                                                <span
                                                    class="badge badge-pill badge-{{$titheOfferingBase->statusColor}} px-2 py-1">{{$titheOfferingBase->status}}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="table-responsive">
                                    <table class="table table-striped table-hover datatable" id="datatable">
                                        <thead>
                                        <tr>
                                            <th style="width: 10px">#</th>
                                            {{--                                            <th>Church</th>--}}
                                            <th>Member Names</th>
                                            <th>Member Phone</th>
                                            <th>Small Group</th>
                                            <th>Offering Type</th>
                                            <th>Amount</th>
                                            <th>Payment Option</th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>


    <div class="modal fade" id="modalUpdate" data-backdrop="static" tabindex="-1" role="dialog"
         aria-labelledby="staticBackdrop" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{route('tithe.and.offering.update')}}" method="post" id="submissionFormEdit"
                  class="submissionForm" enctype="multipart/form-data">
                @csrf
                <input type="hidden" value="0" id="TitheId" name="TitheId">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Edit Tithe And Offering</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="edit-member">Member Names</label>
                                    <select type="text"
                                            onchange="changeMember(this,'#edit_member_names','#edit_member_phone');"
                                            style="width: 100%;" name="MemberId" id="edit-member"
                                            class="form-control custom-select2" required>
                                        <option value="">Select Member Names</option>
                                        @foreach($members as $member)
                                            <option value="{{$member->id}}"
                                                    data-name="{{$member->firstname}} {{$member->lastname}}"
                                                    data-phone="{{$member->phone_number}}">{{$member->firstname}} {{$member->lastname}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit_member_names">Member names </label>
                                    <input type="text" id="edit_member_names" name="member_names" class="form-control"/>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit_member_phone">Member phone </label>
                                    <input type="number" id="edit_member_phone" name="member_phone"
                                           class="form-control"/>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-offering">Offering Type</label>
                                    <select type="text" name="OfferingTypeId" id="edit-offering" class="form-control"
                                            required>
                                        <option value="">Select Offering Type</option>
                                        @foreach($types as $offering)
                                            <option value="{{$offering->id}}">{{$offering->OfferingName}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-amount">Amount </label>
                                    <input type="text" id="edit-amount" name="Amount" class="form-control"
                                           required/>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-payment">Payment Option </label>
                                    <select type="text" name="PaymentOptionId" id="edit-payment" class="form-control"
                                            required>
                                        <option value="">--Select mode --</option>
                                        @foreach($payments as $payment)
                                            <option value="{{$payment->id}}">{{$payment->PaymentOption}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-date">Date </label>
                                    <input type="date" id="edit-date" name="Date" class="form-control"
                                           required/>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
    </div>

@endsection
@section("script")

    <script>


        function changeMember(elem, nm, ph) {
            if ($(elem).val()) {
                $(nm + "," + ph).prop("readonly", true);
            } else {
                $(nm + "," + ph).prop("readonly", false);
            }
            let name = $("option:selected", elem).data('name');
            let phone = $("option:selected", elem).data('phone');
            $(nm).val(name);
            $(ph).val(phone);
        }

        $('.custom-select2').select2()

        $(document).ready(function () {

            $('.datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: `{{ route('tithe.and.offering.create') }}?model_id={{$titheOfferingBase->id}}`,
                columns: [
                    {data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false},
                    {data: 'member_names', name: 'member_names'},
                    {data: 'member_phone', name: 'member_phone'},
                    {data: 'member.smallgroups.group_name', name: 'member.smallgroups.group_name',
                        render: function (data, type, row) {
                            return data? data : 'N/A';
                        }
                    },
                    {data: 'offering.OfferingName', name: 'offering.OfferingName'},
                    {
                        data: 'Amount', name: 'Amount', render: function (data, type, row) {
                            return Number(data).toLocaleString();
                        }
                    },
                    {data: 'payment.PaymentOption', name: 'payment.PaymentOption'},
                    {
                        data: 'Date', name: 'Date',
                        render: function (data, type, row) {
                             return moment(data).format('DD-MM-YYYY');
                        }
                    },
                    {data: 'action', name: 'action', searchable: false, orderable: false},
                ]
            }).order([6, 'desc']);


            $("#submissionForm").validate();
            $("#uploadForm").validate();
            $(document).on('click', '.js-edit', function (e) {
                console.log('clicked');
                e.preventDefault();
                $("#modalUpdate").modal('show');
                var url = $(this).data('url');
                $("#TitheId").val($(this).data('id'));
                $("#edit-company").val($(this).data('company'));
                $("#edit-member").val($(this).data('member')).trigger("change");
                $("#edit-offering").val($(this).data('offering'));
                $("#edit-amount").val($(this).data('amount'));
                $("#edit_member_names").val($(this).data('names'));
                $("#edit_member_phone").val($(this).data('phone'));
                $("#edit-payment").val($(this).data('payment'));
                $("#edit-date").val($(this).data('date'));
                $('#submissionFormEdit').attr('action', url);
            });
            $(document).on('click', '.js-delete', function (e) {
                // console.log('deleted');
                e.preventDefault();
                var href = this.href;
                Swal.fire({
                    title: "Are you sure?",
                    text: "Delete this Tithe And Offering ?",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Yes, delete it!",
                    cancelButtonText: "No, cancel!",
                    reverseButtons: true
                }).then((willDelete) => {
                    if (willDelete.value) {
                        window.location = href;
                    } else {
                        //swal("Your imaginary file is safe!");
                    }
                });
            });
        });

        $('#exampleModalLong').on('hidden.bs.modal', function (e) {
            $('#TitheId').val(0);
            $("#edit-member,#MemberId").val("").trigger("change");
        });

        $('#js-all-delete').on('click', function (e) {
            e.preventDefault();
            const url = $(this).attr('href');
            Swal.fire({
                title: "Are you sure?",
                text: "Delete this Tithe And Offering ?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete it!",
                cancelButtonText: "No, cancel!",
                reverseButtons: true
            }).then((willDelete) => {
                if (willDelete.value) {
                    $.ajax({
                        url: url,
                        type: 'DELETE',
                        data: {
                            _token: '{{csrf_token()}}'
                        },
                        success: function (response) {
                            window.location.href = '{{route('base-offering-tithe.index')}}';
                        },
                        error: function (response) {
                            console.log(response);
                            Swal.fire({
                                title: "Error!",
                                text: "Something went wrong!",
                                icon: "error",
                                confirmButtonText: "Ok",
                            });
                        }
                    });
                }
            });
        });

        $('#btn-approve').on('click', function (e) {
            e.preventDefault();
            let btn = $(this);
            const url = btn.attr('href');
            Swal.fire({
                url: url,
                title: "Are you sure?",
                text: "Approve this Tithe And Offering ?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, approve it!",
                cancelButtonText: "No, cancel!",
                reverseButtons: true
            }).then((willDelete) => {
                if (willDelete.value) {
                    $.ajax({
                        url: url,
                        type: 'POST',
                        data: {
                            _token: '{{csrf_token()}}'
                        },
                        success: function (response) {
                            btn.hide();
                            Swal.fire({
                                title: "Success!",
                                text: "Tithe And Offering has been approved!",
                                icon: "success",
                                confirmButtonText: "Ok",
                            });
                            window.location.href = '{{route('base-offering-tithe.index')}}';
                        },
                        error: function (response) {
                            console.log(response);
                            Swal.fire({
                                title: "Error!",
                                text: "Something went wrong!",
                                icon: "error",
                                confirmButtonText: "Ok",
                            });
                        }
                    });
                }
            });
        });

    </script>

@endsection

