<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, user-scalable=no, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0"/>
    <meta http-equiv="X-UA-Compatible" content="ie=edge"/>
    <title>
        Reports
    </title>
    <link rel="stylesheet" href="{{ asset('css/tailwind.css') }}">
    <style>
        .page-break {
            page-break-after: always;
        }

        html, body {
            font-family: 'Figtree', sans-serif !important;
        }

        .tw-min-w-\[175px\] {
            min-width: 175px;
        }

        .tw-min-w-\[70px\] {
            min-width: 70px;
        }

        .tw-min-w-\[80px\] {
            min-width: 80px;
        }

        .tw-min-w-\[100px\] {
            min-width: 100px;
        }


        .display-1{
            font-size: 3rem;
        }
        .tw-text-justify{
            text-align: justify !important;
        }
        .tw-pointer-events-none {
            pointer-events: none !important
        }

        .tw-absolute {
            position: absolute !important
        }

        .tw-relative {
            position: relative !important
        }

        .tw-inset-0 {
            top: 0 !important;
            right: 0 !important;
            bottom: 0 !important;
            left: 0 !important
        }

        .-tw-top-1 {
            top: -.25rem !important
        }

        .tw-z-10 {
            z-index: 10 !important
        }

        .tw-z-20 {
            z-index: 20 !important
        }

        .tw-m-0 {
            margin: 0 !important
        }

        .tw-mb-1 {
            margin-bottom: .25rem !important
        }

        .tw-mb-11 {
            margin-bottom: 2.75rem !important
        }

        .tw-mb-12 {
            margin-bottom: 3rem !important
        }

        .tw-mb-3 {
            margin-bottom: .75rem !important
        }

        .tw-mb-8 {
            margin-bottom: 2rem !important
        }

        .tw-mb-9 {
            margin-bottom: 2.25rem !important
        }

        .tw-mt-8 {
            margin-top: 2rem !important
        }

        .tw-flex {
            display: flex !important
        }

        .tw-grid {
            display: grid !important
        }

        .tw-h-12 {
            height: 3rem !important
        }

        .tw-h-16 {
            height: 4rem !important
        }

        .tw-w-32 {
            width: 128px !important
        }

        .tw-w-44 {
            width: 11rem !important
        }

        .tw-w-52 {
            width: 13rem !important
        }

        .tw-w-full {
            width: 100% !important
        }

        .tw-min-w-\[100px\] {
            min-width: 100px !important
        }

        .tw-min-w-\[175px\] {
            min-width: 175px !important
        }

        .tw-min-w-\[70px\] {
            min-width: 70px !important
        }

        .tw-min-w-\[80px\] {
            min-width: 80px !important
        }

        .tw-max-w-\[300px\] {
            max-width: 300px !important
        }

        .tw-flex-grow {
            flex-grow: 1 !important
        }

        .-tw-rotate-45 {
            --tw-rotate: -45deg !important;
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y)) !important
        }

        .tw-transform {
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skew(var(--tw-skew-x)) skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y)) !important
        }

        .tw-list-inside {
            list-style-position: inside !important
        }

        .tw-list-disc {
            list-style-type: disc !important
        }

        .tw-grid-cols-1 {
            grid-template-columns:repeat(1, minmax(0, 1fr)) !important
        }

        .tw-grid-cols-2 {
            grid-template-columns:repeat(2, minmax(0, 1fr)) !important
        }

        .tw-flex-col {
            flex-direction: column !important
        }

        .tw-items-center {
            align-items: center !important
        }

        .tw-justify-end {
            justify-content: flex-end !important
        }

        .tw-justify-center {
            justify-content: center !important
        }

        .tw-justify-between {
            justify-content: space-between !important
        }

        .tw-gap-5 {
            gap: 1.25rem !important
        }

        .tw-gap-6 {
            gap: 1.5rem !important
        }

        .tw-overflow-x-auto {
            overflow-x: auto !important
        }

        .tw-border {
            border-width: 1px !important
        }

        .tw-border-b {
            border-bottom-width: 1px !important
        }

        .tw-border-gray-500 {
            --tw-border-opacity: 1 !important;
            border-color: rgb(107 114 128 / var(--tw-border-opacity)) !important
        }

        .tw-bg-gray-50 {
            --tw-bg-opacity: 1 !important;
            background-color: rgb(249 250 251 / var(--tw-bg-opacity)) !important
        }

        .tw-bg-white {
            --tw-bg-opacity: 1 !important;
            background-color: rgb(255 255 255 / var(--tw-bg-opacity)) !important
        }

        .tw-p-10 {
            padding: 2.5rem !important
        }

        .tw-p-2 {
            padding: .5rem !important
        }

        .tw-px-10 {
            padding-left: 2.5rem !important;
            padding-right: 2.5rem !important
        }

        .tw-pb-10 {
            padding-bottom: 2.5rem !important
        }

        .tw-pe-10 {
            padding-inline-end: 2.5rem !important
        }

        .tw-pt-6 {
            padding-top: 1.5rem !important
        }

        .tw-text-left {
            text-align: left !important
        }

        .tw-text-end {
            text-align: end !important
        }

        .tw-font-sans {
            font-family: Figtree, ui-sans-serif, system-ui, sans-serif, "Apple Color Emoji", "Segoe UI Emoji", Segoe UI Symbol, "Noto Color Emoji" !important
        }

        .tw-text-2xl {
            font-size: 1.5rem !important;
            line-height: 2rem !important
        }

        .tw-text-3xl {
            font-size: 1.875rem !important;
            line-height: 2.25rem !important
        }

        .tw-text-6xl {
            font-size: 3.75rem !important;
            line-height: 1 !important
        }

        .tw-text-lg {
            font-size: 1.125rem !important;
            line-height: 1.75rem !important
        }

        .tw-text-sm {
            font-size: .875rem !important;
            line-height: 1.25rem !important
        }

        .tw-text-xl {
            font-size: 1.25rem !important;
            line-height: 1.75rem !important
        }

        .tw-text-xs {
            font-size: .75rem !important;
            line-height: 1rem !important
        }

        .tw-font-bold {
            font-weight: 700 !important
        }

        .tw-font-semibold {
            font-weight: 600 !important
        }

        .tw-uppercase {
            text-transform: uppercase !important
        }

        .tw-ordinal {
            --tw-ordinal: ordinal !important;
            font-variant-numeric: var(--tw-ordinal) var(--tw-slashed-zero) var(--tw-numeric-figure) var(--tw-numeric-spacing) var(--tw-numeric-fraction) !important
        }

        .tw-text-black {
            --tw-text-opacity: 1 !important;
            color: rgb(0 0 0 / var(--tw-text-opacity)) !important
        }

        .tw-text-blue-500 {
            --tw-text-opacity: 1 !important;
            color: rgb(59 130 246 / var(--tw-text-opacity)) !important
        }

        .tw-text-gray-500 {
            --tw-text-opacity: 1 !important;
            color: rgb(107 114 128 / var(--tw-text-opacity)) !important
        }

        .tw-text-gray-600 {
            --tw-text-opacity: 1 !important;
            color: rgb(75 85 99 / var(--tw-text-opacity)) !important
        }

        .tw-text-gray-700 {
            --tw-text-opacity: 1 !important;
            color: rgb(55 65 81 / var(--tw-text-opacity)) !important
        }

        .tw-text-gray-800 {
            --tw-text-opacity: 1 !important;
            color: rgb(31 41 55 / var(--tw-text-opacity)) !important
        }

        .tw-text-green-500 {
            --tw-text-opacity: 1 !important;
            color: rgb(34 197 94 / var(--tw-text-opacity)) !important
        }

        .tw-text-red-500 {
            --tw-text-opacity: 1 !important;
            color: rgb(239 68 68 / var(--tw-text-opacity)) !important
        }

        .tw-text-yellow-500 {
            --tw-text-opacity: 1 !important;
            color: rgb(234 179 8 / var(--tw-text-opacity)) !important
        }

        .tw-antialiased {
            -webkit-font-smoothing: antialiased !important;
            -moz-osx-font-smoothing: grayscale !important
        }

        .tw-opacity-20 {
            opacity: .2 !important
        }

        .js-price {
            width: 11rem
        }

        @media (min-width: 768px) {
            .md\:tw-grid-cols-2 {
                grid-template-columns:repeat(2, minmax(0, 1fr)) !important
            }
        }

        @media (min-width: 1024px) {
            .lg\:tw-grid-cols-2 {
                grid-template-columns:repeat(2, minmax(0, 1fr)) !important
            }

            .lg\:tw-grid-cols-4 {
                grid-template-columns:repeat(4, minmax(0, 1fr)) !important
            }
        }


        .table-striped tbody tr:nth-of-type(odd) {
            background-color: rgba(0, 0, 0, 0.05);
        }

    </style>

</head>
<body class="tw-font-sans tw-antialiased">

<div class="-tw-top-1 tw-p-10 " style="position: relative;">
    <h3>
        Tithe Offering Report
    </h3>


    <div>
        <p class="tw-text-xs">
            <strong>Start Date:</strong> {{ $startDate }} , <strong>End Date:</strong> {{ $endDate }}
        </p>
        <p class="tw-text-xs">
            <strong>Total Count:</strong> {{ number_format($results->sum('offering_count')) }}
        </p>
        <p class="tw-text-xs">
            <strong>Total Mount:</strong> {{ number_format($results->sum('total_amount')) }}
        </p>
        @if($offeringType)
            <p class="tw-text-xs">
                <strong>Offering Type:</strong> {{$offeringType->OfferingName }}
            </p>
        @endif

    </div>

    <table class="table  border table-striped " style=";width: 100% !important;">
        <thead class="tw-text-xs tw-text-gray-700 tw-uppercase">
        <tr class=" tw-border-b tw-text-xs tw-font-bold tw-text-gray-700">
            <td class="tw-p-2">Name</td>
            <td class="tw-p-2">Small Group</td>
            <td class="tw-p-2">count</td>
            <td class="tw-p-2">Total amount</td>
{{--            <td class="tw-p-2">Offering Name</td>--}}
        </tr>
        </thead>

        <tbody>
        @foreach($results as $item)
            <tr class="small tw-text-xs border-bottom">
                <td class=" tw-p-2">{{ $item->name }}</td>
                <td class=" tw-p-2">{{ $item->group_name }}</td>
                <td class=" tw-p-2">{{ $item->offering_count }}</td>
                <td class=" tw-p-2">{{ number_format($item->total_amount) }}</td>
{{--                <td class=" tw-p-2">{{ $item->OfferingName }}</td>--}}
            </tr>
        @endforeach
        </tbody>
    </table>


</div>
</body>
</html>
