@extends("master")
@section("title",auth()->user()->name??"")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark"> {{$submission->report->report_name??''}}</h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Layout</a></li>
                            <li class="breadcrumb-item active">Top Navigation</li>
                        </ol>

                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">

                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title">{{$submission->report->report_name??''}}</h3>
{{--                        <div class="card-tools">--}}
{{--                            <div class="btn-group">--}}
{{--                                <button class="btn btn-success"><i class="fa fa-upload"></i> Upload Excel</button>--}}
{{--                                <button class="btn btn-primary"><i class="fa fa-file-excel"></i> Excel Template</button>--}}
{{--                            </div>--}}
{{--                        </div>--}}
                    </div>


                    <div class="card-body">
                        <table class="table table-striped table-hover" id="table">
                            <thead>
                            <tr>
                                <th style="width: 10px">#</th>
                                <th>Indicator Name</th>
                                <th>Value</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                    @if($submission->status == "DRAFT")
                    <div class="card-footer clearfix">
                        <button class="btn btn-primary float-right btn-submit">Submit Report</button>
                    </div>
                    @endif
                </div><!-- /.card -->
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>


    <!-- /.modal -->
    <!-- /.content-wrapper -->
    <!-- Control Sidebar -->
@endsection

@section("script")
    <!-- Laravel Javascript Validation -->
    {{--    <script src="https://unpkg.com/sweetalert2@7.18.0/dist/sweetalert2.all.js"></script>--}}
    {{--    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>--}}
    {{--    {!! JsValidator::formRequest('App\Http\Requests\ValidateManufacture', '.submissionForm'); !!}--}}
    <script>

        let indicators = {!! json_encode($submission->report->indicators) !!};

        let data = {!! json_encode($submission->data) !!};
        let activeIndex = 0;

        let isDraft = "{{$submission->status}}" === "DRAFT";

        $(function () {


            indicators.forEach(function (v) {
                v.value = data.find(x=>x.indicator_id === v.id)?.indicator_value;
            });

            activeIndex = indicators.findIndex(v=>!v.value);

            buildData();

        });


        function buildData() {

            let body = $("#table").find('tbody');
            body.empty();

            indicators.forEach(function (v, i) {
                let tr = document.createElement("tr");

                let td = document.createElement("td");
                td.innerText = i + 1;
                tr.appendChild(td);

                let td2 = document.createElement("td");
                td2.innerText = v.indicator_name;
                tr.appendChild(td2);

                let td3 = document.createElement("td");

                let disabled = activeIndex !== i || !isDraft;


                let relative = document.createElement("div");
                relative.className = "position-relative";


                let error = document.createElement("div");
                error.className = "position-absolute top-100 left-0 bg-danger py-1 px-5 mt-2 text-white rounded-sm user-options";
                error.style.zIndex = 40000;
                error.style.display = v.invalid ? "block":"none";
                error.textContent = "Field is required";

                relative.appendChild(error);

                function onchange() {
                    v.value = this.value;
                    error.style.display = !this.value ? "block":"none";
                }

                if(!isDraft){
                    if(v.indicator_value_type === 'Boolean'){
                        let span = document.createElement("span");
                        span.className = "badge "+(v.value === "1" ? "badge-success":"badge-danger");
                        span.textContent = v.value === "1" ? "Yes" : "No";
                        relative.appendChild(span);
                    }else{

                        let span = document.createElement("span");
                        span.textContent = v.value;
                        relative.appendChild(span);
                    }
                }
                else if (v.indicator_value_type === "dropdown") {
                    let select = document.createElement("select");
                    select.className = 'form-control';
                    select.disabled = disabled;
                    let def = document.createElement("option");
                    def.value = "";
                    def.innerText = "-- select --";
                    select.appendChild(def);
                    select.onchange = onchange;
                    v.drop_down_data_source.forEach(function (vd) {
                        let opt = document.createElement("option");
                        opt.innerText = vd;
                        opt.selected = v.value?.toString() === vd?.toString();
                        select.appendChild(opt);
                    })
                    relative.appendChild(select);
                } else if (v.indicator_value_type === 'Boolean') {

                    let select = document.createElement("select");
                    select.className = 'form-control';
                    select.disabled = disabled;
                    select.onchange = onchange;
                    let def = document.createElement("option");
                    def.value = "";
                    def.innerText = "-- select --";
                    select.appendChild(def);
                    [{name: "Yes", value: 1}, {name: "No", value: 0}].forEach(function (vd) {
                        let opt = document.createElement("option");
                        opt.value = vd.value;
                        opt.innerText = vd.name;
                        opt.selected = v.value?.toString() === vd.value.toString();
                        select.appendChild(opt);
                    })
                    relative.appendChild(select);
                }else{
                    let input = document.createElement("input");
                    input.className = 'form-control';
                    input.disabled = disabled;
                    input.value = v.value ?? "";

                    if(v.indicator_value_type === "Date"){
                        input.onchange = onchange;
                    }else
                        input.onkeyup = onchange;
                    input.type = v.indicator_value_type?.toLowerCase();

                    relative.appendChild(input);

                }


                td3.appendChild(relative);

                tr.appendChild(td3);


                let td4 = document.createElement("td");
                if(!disabled || !v.value || v.saving) {
                    if(isDraft){
                        let save = document.createElement("button");
                        save.className = "btn btn-outline-primary";
                        save.onclick = function () {
                            v.invalid = !v.value;
                            v.saving = !v.invalid;

                            if (v.saving) {
                                $.ajax({
                                    url: "{{route('reporting.data.submit.row',$submission->id)}}",
                                    method: "POST",
                                    data: {
                                        _token: "{{csrf_token()}}",
                                        value: v.value,
                                        indicator_id: v.id,
                                    },
                                    success: function () {
                                        activeIndex = indicators.findIndex(x=>!x.value);
                                    },
                                    complete: function () {
                                        v.saving = false;
                                        buildData();
                                    }
                                })
                            }
                            buildData();
                        }
                        save.innerHTML = "<i class='fa " + (v.saving ? 'fa-save fa-spin' : 'fa-save') + "'></i> Save";
                        td4.appendChild(save);
                    }
                }else if(isDraft){

                    let save = document.createElement("button");
                    save.className = "btn btn-outline-primary";
                    save.onclick = function () {
                        activeIndex = i;
                        buildData();
                    }
                    save.innerHTML = "<i class='fa fa-edit'></i> Edit";
                    td4.appendChild(save);
                }



                tr.appendChild(td4);

                body.append(tr);
            })
        }


        $(document).on('click','.btn-submit',function (e) {
            e.preventDefault();
            Swal.fire({
                title: "Are you sure?",
                text: "Submit this report ?",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, Submit!",
                cancelButtonText: "No, cancel!",
                reverseButtons: true
            }).then((willDelete) => {
                if (willDelete.value) {
                    window.location = "{{route('reporting.data.submit.final',$submission->id)}}";
                } else {
                    //swal("Your imaginary file is safe!");
                }
            });
        });

    </script>

    <style>

        .top-100{
            top: 100%;
        }
        .user-options {
            background: none repeat scroll 0 0 #eeeeee;
            position: absolute;
            z-index: 999;
        }

        .user-options:after, .user-options:before {
            bottom: 100%;
            left: 10%;
            border: solid transparent;
            content: " ";
            height: 0;
            width: 0;
            position: absolute;
            pointer-events: none;
        }

        .user-options:before {
            border-color: rgba(204, 204, 204, 0);
            border-bottom-color: #F64E60;
            border-width: 8px;
            margin-left: 0;
        }
    </style>
@endsection
