@extends("master")
@section("title",auth()->user()->name??"")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark"> Reporting Submissions </h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Layout</a></li>
                            <li class="breadcrumb-item active">Top Navigation</li>
                        </ol>

                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                {{--                                <div class="float-right">--}}
                                {{--                                    <a href="#" class="btn btn-success btn-sm btn-create">--}}
                                {{--                                        <span class="fa fa-user-plus"></span> New Payment Option</a>--}}
                                {{--                                </div>--}}
                                <div class="card-toolbar">
                                    <!-- Button trigger modal-->
                                    <button type="button" class="btn btn-success btn-sm btn-create float-right"
                                            data-toggle="modal"
                                            data-target="#exampleModalLong">
                                        <span class=""></span>
                                        New Report Submission
                                    </button>
                                    <!-- Modal-->
                                </div>
                            </div>


                            <div class="card-body">
                                <table class="table table-striped table-hover data-table">
                                    <thead>
                                    <tr>
                                        <th style="width: 10px">#</th>
                                        <th>Report Definition</th>
                                        <th>Year</th>
                                        <th>Created At</th>
                                        <th>Submitted By</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($reportings as $key=>$reporting)

                                        <tr>
                                            <td>{{++$key}}</td>
                                            <td>{{$reporting->report->report_name??''}}</td>
                                            <td>{{$reporting->year}}</td>
                                            <td>{{$reporting->created_at}}</td>
                                            <td>{{$reporting->user->name??''}}</td>
                                            <td>
                                                @if($reporting->status == "DRAFT")
                                                <div class="btn-group btn-group-sm">
                                                    <a href="{{route('reporting.data.edit',$reporting->id)}}"
                                                       class="btn btn-primary"><span class="fa fa-edit"></span>
                                                    </a>
                                                    <a href="{{route('reporting.data.delete',$reporting->id)}}"
                                                       class="btn btn-danger js-delete"><span
                                                            class="fa fa-trash"></span> </a>
                                                </div>
                                                @else

                                                    <a href="{{route('reporting.data.edit',$reporting->id)}}"
                                                       class="btn btn-outline-primary btn-sm"><span class="fa fa-eye"> View</span>
                                                    </a>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="card-footer clearfix">
                                {{--                                {{$list->links()}}--}}
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>

    <div class="modal fade" id="exampleModalLong" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form action="{{route('reporting.data.store')}}" method="post" id="submissionForm"
                  class="submissionForm" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">New Report Submission</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="report_id">Report Definition </label>
                                    {{--                            <input type="text" id="report_name" name="report_name" class="form-control"/>--}}
                                    <select type="text" name="report_id" id="report_id" class="form-control" required>
                                        <option value="">Select Report Definition</option>
                                        @foreach($definitions as $report)
                                            <option value="{{$report->id}}" data-frequency="{{$report->frequency}}">{{$report->report_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>

                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group date-div" style="display: none">
                                    <label for="date">Date </label>
                                    <input type="date" id="date" name="date" class="form-control"/>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 month-div" style="display: none">
                                <div class="form-group">
                                    <label for="month">Month </label>
                                    <select name="month" type="number" id="month" class="form-control" required>
                                        <option value="">-- Select month --</option>
                                        @for ($m=1; $m<=12; $m++) {
                                            <option value="{{$m}}">{{date('F', mktime(0,0,0,$m, 1, date('Y')))}}</option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 quarter-div" style="display: none">
                                <div class="form-group">
                                    <label for="quarter">Quarter </label>
                                    <select name="quarter" type="number" id="quarter" class="form-control" required>
                                        <option value="">-- Select year --</option>
                                        @for ($m=0; $m<=3; $m++) {
                                        <option value="{{$m+1}}">Quarter {{$m+1}}</option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="year">Year </label>
                                    <select name="year" type="number" id="year" class="form-control" required>
                                        <option value="">-- Select year --</option>
                                        @for ($m=0; $m<=now()->year-2016; $m++) {
                                        <option value="{{$m+2018}}">{{$m+2018}}</option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                        </div>




                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- /.modal -->
    <!-- /.content-wrapper -->
    <!-- Control Sidebar -->
@endsection

@section("script")
    <!-- Laravel Javascript Validation -->
    {{--    <script src="https://unpkg.com/sweetalert2@7.18.0/dist/sweetalert2.all.js"></script>--}}
    {{--    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>--}}
    {{--    {!! JsValidator::formRequest('App\Http\Requests\ValidateManufacture', '.submissionForm'); !!}--}}
    <script>

        $(document).ready(function () {
            $("#submissionForm").validate();

            $(document).on('change','#report_id',function () {
                let $fq = $("option:selected",this).data('frequency');


                $(".date-div").hide();
                $(".month-div").hide();
                $(".quarter-div").hide();

                if($fq === "Weekly"){
                    $(".date-div").show();
                }else if($fq === "Monthly"){
                    $(".month-div").show();
                }else if($fq === "Quarterly"){
                    $(".quarter-div").show();
                }
            });

            $(document).on('click', '.js-edit', function (e) {
                console.log('clicked');
                e.preventDefault();
                $("#modalUpdate").modal('show');
                console.log($(this).data('id'));
                console.log($(this).data('name'));
                var url = $(this).data('url');
                $("#ReportingId").val($(this).data('id'));
                $("#edit_report_id").val($(this).data('report'));
                $("#edit_submitted_by").val($(this).data('submitted'));
                $("#edit_date").val($(this).data('date'));
                $("#edit_month").val($(this).data('month'));
                $("#edit_quarter").val($(this).data('quarter'));
                $("#edit_year").val($(this).data('year'));
                $('#submissionFormEdit').attr('action', url);
            });
            $(document).on('click', '.js-delete', function (e) {
                // console.log('deleted');
                e.preventDefault();
                var href = this.href;
                Swal.fire({
                    title: "Are you sure?",
                    text: "Delete this Reporting Data ?",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Yes, delete it!",
                    cancelButtonText: "No, cancel!",
                    reverseButtons: true
                }).then((willDelete) => {
                    if (willDelete.value) {
                        window.location = href;
                    } else {
                        //swal("Your imaginary file is safe!");
                    }
                });
            });
        });

        $('#exampleModal').on('hidden.bs.modal', function (e) {
            $('#ReportingId').val(0);
        });

    </script>

@endsection
