

@extends("master")
@section("title",$company->name??"")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark"> Payment Option </h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Layout</a></li>
                            <li class="breadcrumb-item active">Top Navigation</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                <div class="card-toolbar">
                                    <!-- Button trigger modal-->
                                    <button type="button" class="btn btn-success btn-sm btn-create float-right" data-toggle="modal"
                                            data-target="#exampleModalLong">
                                        <span class=""></span>
                                        Add New Payment Option
                                    </button>
                                    <!-- Modal-->
                                </div>
                            </div>


                            <div class="card-body">
                                <table class="table table-striped table-hover data-table">
                                    <thead>
                                    <tr>
                                        <th style="width: 10px">#</th>
                                        <th>Payment Option</th>
                                        <th>Active</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($options as $key=>$option)

                                        <tr >
                                            <td>{{++$key}}</td>
                                            <td>{{$option->PaymentOption}}</td>
                                            @if($option->Is_Active == 1)
                                                <td>Yes</td>
                                            @else
                                                <td>No</td>
                                            @endif
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="#" data-company="{{$option->CompanyId}}" data-date=""
                                                       data-id="{{$option->id}}"
                                                       data-name="{{$option->PaymentOption}}"
                                                       data-active="{{$option->Is_Active}}"
                                                       class="btn btn-primary js-edit"><span class="fa fa-edit"></span> </a>
                                                    <a href="{{route('payment.option.delete',$option->id)}}" class="btn btn-danger js-delete"><span
                                                            class="fa fa-trash"></span> </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="card-footer clearfix">
                                {{--                                {{$list->links()}}--}}
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>

    <div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form action="{{route('payment.option.store')}}" method="post" id="submissionForm" class="submissionForm" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="form-group">
                            <label for="PaymentOption">Payment Option</label>
                            <input type="text" id="PaymentOption" name="PaymentOption" class="form-control"
                                   required/>
                        </div>


                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="modalUpdate" data-backdrop="static" tabindex="-1" role="dialog"
         aria-labelledby="staticBackdrop" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{route('payment.option.update')}}" method="post" id="submissionFormEdit" class="submissionForm" enctype="multipart/form-data">
                @csrf
                <input type="hidden" value="0"  id="PaymentOptionId" name="PaymentOptionId">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Edit Payment Option</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="form-group">
                            <label for="PaymentOption">Payment Option</label>
                            <input type="text" id="edit-name" name="PaymentOption" class="form-control"
                                   required/>
                        </div>

                        <div class="form-group">
                            <label for="Is_Active">Active</label>
                            <select type="text" name="Is_Active" id="edit-active" class="form-control" required>
                                <option value="">Select</option>
                                <option value="1">Yes</option>
                                <option value="0">No</option>
                            </select>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
    </div>
    <!-- /.modal -->
    <!-- /.content-wrapper -->
    <script>
        $(function () {
            $(".btn-create").click(function (e) {
                $("#modal-default").modal("show");
            });
        })
    </script>
    <!-- Control Sidebar -->
@endsection

@section("script")
    <!-- Laravel Javascript Validation -->
    {{--    <script src="https://unpkg.com/sweetalert2@7.18.0/dist/sweetalert2.all.js"></script>--}}
    {{--    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>--}}
    {{--    {!! JsValidator::formRequest('App\Http\Requests\ValidateManufacture', '.submissionForm'); !!}--}}
    <script>

        $(document).ready(function() {
            $("#submissionForm").validate();
            $("#submissionFormEdit").validate();
            $(document).on('click', '.js-edit', function (e) {
                console.log('clicked');
                e.preventDefault();
                $("#modalUpdate").modal('show');
                console.log($(this).data('id'));
                console.log($(this).data('name'));
                var url = $(this).data('url');
                $("#PaymentOptionId").val($(this).data('id'));
                $("#edit-company").val($(this).data('company'));
                $("#edit-name").val($(this).data('name'));
                $("#edit-active").val($(this).data('active'));
                $('#submissionFormEdit').attr('action', url);
            });
            $(document).on('click', '.js-delete', function (e) {
                // console.log('deleted');
                e.preventDefault();
                var href = this.href;
                Swal.fire({
                    title: "Are you sure?",
                    text: "Delete this Payment Option Type ?",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Yes, delete it!",
                    cancelButtonText: "No, cancel!",
                    reverseButtons: true
                }).then((willDelete) => {
                    if (willDelete.value) {
                        window.location = href;
                    } else {
                        //swal("Your imaginary file is safe!");
                    }
                });
            });

            $('#exampleModal').on('hidden.bs.modal', function (e) {
                $('#PaymentOptionId').val(0);
            });
        } );



    </script>

@endsection

