<!DOCTYPE html>
<html lang="en">
<head>
    <title>@yield("title")</title>

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="x-ua-compatible" content="ie=edge">

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:ital,wght@0,300..900;1,300..900&display=swap" rel="stylesheet">
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="{{ asset('stylesheets/all.css') }}">
    <!-- Theme style -->

    <link rel="stylesheet" href="{{ asset('stylesheets/adminlte.min.css') }}">
    <link rel="stylesheet" href="{{ asset('stylesheets/index.css') }}">
    <link rel="stylesheet" href="{{ asset('css/tailwind.css') }}">
{{--    <link href="https://cdn.datatables.net/1.10.16/css/jquery.dataTables.min.css" rel="stylesheet">--}}
    <link href="https://cdn.datatables.net/1.10.19/css/dataTables.bootstrap4.min.css" rel="stylesheet">
    <script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <link rel='stylesheet' href='https://cdn.jsdelivr.net/npm/sweetalert2@10.10.1/dist/sweetalert2.min.css'>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet"/>
    @livewireStyles

    <style>
        .hide {
            display: none !important;
        }

        .dataTables_wrapper .dataTables_paginate .paginate_button {
            padding: 0 !important;
        }

        table.dataTable.no-footer {
            border-bottom: 1px solid #e8e6e6;
        }

        table.dataTable thead th, table.dataTable thead td {
            padding: 10px 18px;
            border-bottom: 1px solid #e8e6e6;
        }
    </style>
</head>
<body class="hold-transition layout-top-nav tw-antialiased">
<div class="wrapper">
    <x-app-header/>
    <div class="content-wrapper">
        <div class="container pt-4">
            @include('partial._alerts')
        </div>
        @yield("body")
    </div>


    <aside class="control-sidebar control-sidebar-dark">
        <!-- Control sidebar content goes here -->
        <div class="p-3">
            <h5>Title</h5>
            <p>Sidebar content</p>
        </div>
    </aside>
    <!-- /.control-sidebar -->

    <!-- Main Footer -->
    <x-app-footer/>
    @livewireScripts    <script src="{{mix('js/app.js')}}"></script>
    {{--    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.js"></script>--}}
    <script src="https://cdn.datatables.net/1.10.16/js/jquery.dataTables.min.js"></script>
    {{--    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/js/bootstrap.min.js"></script>--}}
    <script src="https://cdn.datatables.net/1.10.19/js/dataTables.bootstrap4.min.js"></script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.18.1/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.full.min.js"></script>
    {{--    <script src="{{asset('build/scss/plugins\select2/js/select2.full.min.js')}}"></script>--}}


    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>

    <script>
        $(function () {
            var $modal = $('.modal');
            $modal.attr('data-backdrop', 'static');
            $modal.on('hidden.bs.modal',
                function (e) {
                    let form = $(this).find("form")[0];
                    if (form) {
                        form.reset();
                        $('.form-control,.custom-select').removeClass('error');
                        $('label.error').text("");
                    }
                });
            $(".data-table").DataTable();
        })
    </script>

    @yield('script')

    <style>

        .select2-container--default .select2-selection--single {
            border: 1px solid #ced4da;
            padding: 0.46875rem 0.75rem;
            height: calc(2.25rem + 2px) !important;
        }
    </style>
</div>

</body>
</html>

