<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container">
            <div class="row mb-2">
                <div class="col-sm-8">
                    <h4 class="m-0 text-dark"> Tithe And Offering </h4>
                    <p>
                        This report shows the tithe and offering received by each member from the start
                        date
                        to the end date.
                    </p>
                </div><!-- /.col -->
                <div class="col-sm-4">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                        <li class="breadcrumb-item active">
                            Tithe And Offering Report
                        </li>
                    </ol>

                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <div class="content">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">

                    <div class="card card-primary card-outline">
                        <div class="card-body">
                            <div
                                class="d-flex  flex-column flex-lg-row justify-content-between align-items-lg-center mb-3">
                                <div>
                                    <h6>Report</h6>
                                    <p>
                                        Tithe and Offering Report
                                    </p>
                                </div>
                                <form class="d-flex flex-column flex-lg-row flex-shrink-0" style="gap: 10px"
                                      action="{{route('reports.export-tithe-offering-report')}}"
                                      target="_blank">

                                    <div class="form-group">
                                        <input type="date" wire:model.live.debounce="startDate" class="form-control"
                                               id="start_date"
                                               name="start_date" required>
                                    </div>
                                    <div class="form-group">
                                        <input type="date" wire:model.live.debounce="endDate" class="form-control"
                                               id="end_date" name="end_date"
                                               required>
                                    </div>
                                    <div class="form-group">

                                        <select class="form-control" id="offering_type_id"
                                                wire:model.live="offeringTypeId"
                                                name="offering_type_id">
                                            <option value="">Offering Type</option>
                                            @foreach(\App\OfferingType::all() as $offering_type)
                                                <option
                                                    value="{{ $offering_type->id }}">{{ $offering_type->OfferingName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <button type="submit" class="btn btn-success"> Export</button>
                                    </div>
                                </form>
                            </div>

                            <div>
                                <div  wire:loading.flex class=" justify-content-center align-items-center tw-gap-2">
                                    <i class="fa fa-spin fa-spinner"></i> Please wait...
                                </div>
                            </div>

                            <div wire:loading.class="tw-opacity-20">
                                <div class="card card-body my-3 shadow-sm border">
                                    <div class="row">
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label for="start_date" class="font-weight-bolder">Start Date:</label>
                                                <div>{{$startDate}}</div>
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label for="start_date" class="font-weight-bolder">End Date:</label>
                                                <div>{{$endDate}}</div>
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label for="start_date" class="font-weight-bolder">Total Count:</label>
                                                <div>
                                                    {{ number_format($data->sum('offering_count')) }}
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-3">
                                            <div class="form-group">
                                                <label for="start_date" class="font-weight-bolder">Total Amount:</label>
                                                <div>
                                                    {{ number_format($data->sum('total_amount')) }}
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>

                                <div class="table-responsive" style="height: 90vh;">
                                    <table class="table table-head-fixed text-nowrap">
                                        <thead>
                                        <tr>
                                            <th>Member Name</th>
                                            <th>Small Group</th>
                                            <th>Count</th>
                                            <th>Total Amount</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($data as $item)
                                            <tr>
                                                <td class=" tw-p-2">{{ $item->name }}</td>
                                                <td class=" tw-p-2">{{ $item->group_name }}</td>
                                                <td class=" tw-p-2">{{ number_format($item->offering_count) }}</td>
                                                <td class=" tw-p-2">{{ number_format($item->total_amount) }}</td>
                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>

                            </div>
                        </div>
                    </div><!-- /.card -->
                </div>
                <!-- /.col-md-6 -->
                <!-- /.col-md-6 -->
            </div>
            <!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content -->
</div>
