@extends("master")
@section("title",auth()->user()->name??"")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark"> Indicator Definition </h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Layout</a></li>
                            <li class="breadcrumb-item active">Top Navigation</li>
                        </ol>

                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                <h3 class="card-title">{{$definition->report_name??''}}</h3>
                                {{--                                <div class="float-right">--}}
                                {{--                                    <a href="#" class="btn btn-success btn-sm btn-create">--}}
                                {{--                                        <span class="fa fa-user-plus"></span> New Payment Option</a>--}}
                                {{--                                </div>--}}
                                <div class="card-toolbar">
                                    <!-- Button trigger modal-->
                                    <button type="button" class="btn btn-success btn-sm btn-create float-right"
                                            data-toggle="modal"
                                            data-target="#exampleModalLong">
                                        <span class=""></span>
                                        Add New Indicator
                                    </button>
                                    <!-- Modal-->
                                </div>
                            </div>


                            <div class="card-body">
                                <table class="table table-striped table-hover data-table">
                                    <thead>
                                    <tr>
                                        <th style="width: 10px">#</th>
{{--                                        <th>Report Definition</th>--}}
{{--                                        <th>Church</th>--}}
                                        <th>Indicator Name</th>
                                        <th>Indicator Value Type</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($indicators as $key=>$indicator)

                                        <tr>
                                            <td>{{++$key}}</td>
{{--                                            <td>{{$indicator->report->report_name??''}}</td>--}}
{{--                                            <td>{{$indicator->company->name??''}}</td>--}}
                                            <td>{{$indicator->indicator_name}}</td>
                                            <td>{{$indicator->indicator_value_type}}</td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="#" data-report="{{$indicator->report_id}}"
                                                       data-id="{{$indicator->id}}"
                                                       data-company="{{$indicator->company_id}}"
                                                       data-indicator="{{$indicator->indicator_name}}"
                                                       data-value="{{$indicator->indicator_value_type}}"
                                                       data-source="{{json_encode($indicator->drop_down_data_source)}}"
                                                       class="btn btn-primary js-edit"><span class="fa fa-edit"></span>
                                                    </a>
                                                    <a href="{{route('indicator.definition.delete',$indicator->id)}}"
                                                       class="btn btn-danger js-delete"><span
                                                            class="fa fa-trash"></span> </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="card-footer clearfix">
                                {{--                                {{$list->links()}}--}}
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>

    <div class="modal fade" id="exampleModalLong" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form action="{{route('indicator.definition.store')}}" method="post" id="submissionForm"
                  class="submissionForm" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Add Indicator Definition</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <input type="hidden" value="{{$definition->id}}" name="report_id" id="report_id">
                        <div class="form-group">
                            <label for="indicator_name">Indicator Name</label>
                            <input type="text" id="indicator_name" name="indicator_name" class="form-control"/>
                        </div>

                        <div class="form-group">
                            <label for="indicator_value_type">Indicator Value Type</label>
                            {{--                            <input type="text" id="indicator_value_type" name="indicator_value_type" class="form-control"/>--}}
                            <select type="text" id="indicator_value_type" name="indicator_value_type"
                                    class="form-control">
                                <option value="">Select Indicator Value Type</option>
                                <option value="Number">Number</option>
                                <option value="Boolean">Boolean</option>
                                <option value="Text">Text</option>
                                <option value="Date">Date</option>
                                <option value="dropdown">Dropdown</option>
                            </select>
                        </div>

                        <div id="dataSourceContainer" class="form-group hide">
                            <label for="drop_down_data_source" class="data-source-label">Drop Down Data Source</label>
                            {{--                            <input type="text" id="indicator_value_type" name="indicator_value_type" class="form-control"/>--}}
                            <select type="text" id="drop_down_data_source" name="drop_down_data_source[]"
                                    class="form-control showing" multiple="multiple"></select>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="modalUpdate" data-backdrop="static" tabindex="-1" role="dialog"
         aria-labelledby="staticBackdrop" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{route('indicator.definition.update')}}" method="post" id="submissionFormEdit"
                  class="submissionForm" enctype="multipart/form-data">
                @csrf
                <input type="hidden" value="0" id="IndicatorId" name="IndicatorId">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Edit Indicator Definition</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <input type="hidden" value="{{$definition->id}}" name="report_id" id="report_id">

                        <div class="form-group">
                            <label for="edit_indicator_name">Indicator Name</label>
                            <input type="text" id="edit_indicator_name" name="indicator_name" class="form-control"/>
                        </div>

                        <div class="form-group" id="indicator_value_type">
                            <label for="edit_indicator_value_type">Indicator Value Type</label>
                            <select type="text" id="edit_indicator_value_type" name="indicator_value_type"
                                    class="form-control">
                                <option value="">Select Indicator Value Type</option>
                                <option value="Number">Number</option>
                                <option value="Boolean">Boolean</option>
                                <option value="Text">Text</option>
                                <option value="Date">Date</option>
                                <option value="dropdown">Dropdown</option>
                            </select>
                        </div>

                        <div id="edit_data_source_container" class="form-group hide">
                            <label for="edit_drop_down_data_source" class="data-source-label">Drop Down Data Source</label>
                            <select type="text" id="edit_drop_down_data_source" name="drop_down_data_source[]"
                                    class="form-control showing" multiple="multiple">

                            </select>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
    </div>
    <!-- /.modal -->
    <!-- /.content-wrapper -->
    <!-- Control Sidebar -->
@endsection

@section("script")
    <!-- Laravel Javascript Validation -->
    {{--    <script src="https://unpkg.com/sweetalert2@7.18.0/dist/sweetalert2.all.js"></script>--}}
    {{--    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>--}}
    {{--    {!! JsValidator::formRequest('App\Http\Requests\ValidateManufacture', '.submissionForm'); !!}--}}
    <script>

        $(document).ready(function () {

            $('#indicator_value_type').on('change', function () {
                    if ($(this).val() ==="dropdown") {
                        $('#dataSourceContainer').removeClass('hide');
                    } else {
                        $('#dataSourceContainer').addClass('hide');
                    }
                }
            );

            $('#edit_indicator_value_type').on('change', function () {
                    if ($(this).val() ==="dropdown") {
                        $('#edit_data_source_container').removeClass('hide');
                    } else {
                        $('#edit_data_source_container').addClass('hide');
                    }
                }
            );
        });

        $('.custom-select2').select2()

        $('.showing').select2({
            tags: true,
            tokenSeparators: [],
            width: 465
        })

        $(document).ready(function () {
            $("#submissionForm").validate();
            $(document).on('click', '.js-edit', function (e) {
                e.preventDefault();
                $("#modalUpdate").modal('show');
                console.log($(this).data('id'));
                console.log($(this).data('name'));
                var url = $(this).data('url');
                $("#IndicatorId").val($(this).data('id'));
                $("#edit_indicator_name").val($(this).data('indicator'));
                $("#edit_indicator_value_type").val($(this).data('value')).trigger('change');
                let source = $(this).data('source');

                let obj = $("#edit_drop_down_data_source");
                source.forEach(function (v) {
                    let opt = document.createElement("option");
                    opt.value = v;
                    opt.selected = true;
                    opt.innerText = v;
                    obj.append(opt);
                });
                obj.trigger('change');
                $("#edit_report_id").val($(this).data('report'));
                $('#submissionFormEdit').attr('action', url);
            });
            $(document).on('click', '.js-delete', function (e) {
                // console.log('deleted');
                e.preventDefault();
                var href = this.href;
                Swal.fire({
                    title: "Are you sure?",
                    text: "Delete this Indicator Definition ?",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Yes, delete it!",
                    cancelButtonText: "No, cancel!",
                    reverseButtons: true
                }).then((willDelete) => {
                    if (willDelete.value) {
                        window.location = href;
                    } else {
                        //swal("Your imaginary file is safe!");
                    }
                });
            });
        });

        $('#exampleModal').on('hidden.bs.modal', function (e) {
            $('#IndicatorId').val(0);
        });

        $('#modalUpdate').on('hidden.bs.modal', function (e) {
            $('#edit_drop_down_data_source').empty().trigger('change');
        });

    </script>

@endsection
