

@extends("master")
@section("title",$company->name??"")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark"> Visit history</h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Layout</a></li>
                            <li class="breadcrumb-item active">Top Navigation</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                <div class="float-right">
                                    <a href="{{route("export")}}?{{request()->has("start_date") ? 'start_date='.request("start_date") : "val"}}{{request()->has("end_date") ? '&end_date='.request("end_date") : ""}}{{request()->has("query") ? '&query='.request("query") : ""}}" class="btn btn-success btn-sm"><span class="fa fa-file-excel"></span> Export to excel</a></div>
                                <form action="" method="get">
                                    <div class="form-inline">
                                        <div class="form-group">
                                            <input type="date" id="start-date" title="Start date" value="{{request("start_date")}}" name="start_date" class="form-control form-control-sm" placeholder="Start date">
                                        </div>
                                        <div class="form-group ml-3">
                                            <input type="date" id="end-date" title="End date" value="{{request("end_date")}}"  name="end_date" class="form-control form-control-sm" placeholder="End date">
                                        </div>
                                        @if( request()->has("query"))
                                            <input name="query" value="{{request("query")}}" class="form-control form-control-navbar" type="hidden"
                                                   placeholder="Search" aria-label="Search">
                                            @endif
                                        <div class="form-group ml-3">
                                            <button class="btn btn-primary btn-sm">Search history</button>
                                        </div>
                                    </div>
                                </form>

                            </div>
                            <div class="card-body">
                                <div class="table-responsive">

                                    <table class="table table-striped table-hover datatable">
                                        <thead>
                                        <tr>
                                            <th style="width: 10px">#</th>
                                            <th>Names</th>
                                            <th>Phone</th>
                                            <th>Date</th>
                                            <th>Temperature</th>
                                            <th>Vaccination</th>
                                            <th>Vaccination code</th>
                                        </tr>
                                        </thead>
                                        <tbody>
{{--                                        @foreach($list as $key=>$item)--}}

{{--                                            <tr >--}}
{{--                                                <td>{{++$key}}</td>--}}
{{--                                                <td>{{$item->individual->names}}</td>--}}
{{--                                                <td>{{$item->individual->phone}}</td>--}}
{{--                                                <td>--}}
{{--                                                    {{$item->created_at}}--}}
{{--                                                </td>--}}
{{--                                                <td>--}}
{{--                                                    {{$item->temperature}}--}}
{{--                                                </td>--}}
{{--                                                <td>--}}
{{--                                                    {{$item->vaccination??''}}--}}
{{--                                                </td>--}}
{{--                                                <td>--}}
{{--                                                    {{$item->vaccination_code??''}}--}}
{{--                                                </td>--}}
{{--                                            </tr>--}}
{{--                                        @endforeach--}}
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="card-footer clearfix">
{{--                                {{$list->links()}}--}}
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <!-- Control Sidebar -->
    @endsection


@section("script")
    <script type="text/javascript">
        $(function () {

            $('.datatable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('visit.history') }}?start_date={{request('start_date')}}&end_date={{request('end_date')}}",
                columns: [
                    { data: 'DT_RowIndex', name: 'DT_RowIndex', orderable: false, searchable: false },
                    {data: 'individual.names', name: 'individual.names'},
                    {data: 'individual.phone', name: 'individual.phone'},
                    {data: 'created_at', name: 'created_at',render:function (data) {
                            return moment(data).format("YYYY-MM-DD");
                        }},
                    {data: 'temperature', name: 'temperature'},
                    {data: 'vaccination', name: 'vaccination'},
                    {data: 'vaccination_code', name: 'vaccination_code'},
                ]
            });

        });
    </script>
@endsection

