@extends("master")
@section("title",auth()->user()->company->name??"")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper" style="min-height: 612px;">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0">Dashboard</h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item active">Dashboard</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <section class="content">
            <div class="container">
                <!-- Small boxes (Stat box) -->
                <div class="row">
                    <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-info">
                            <div class="inner">
                                <h3>{{convertToBMK($totalMembers)}}</h3>
                                <p>Members</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-bag"></i>
                            </div>
                            <a href="#" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-success">
                            <div class="inner">
                                <h3 title="{{ number_format($offeringAmount) }}">{{convertToBMK($offeringAmount)}} RWF</h3>
                                <p>Offerings</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-stats-bars"></i>
                            </div>
                            <a href="#" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-warning">
                            <div class="inner">
                                <h3>{{convertToBMK($totalSmallGroups)}}</h3>

                                <p>Small Groups</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-person-add"></i>
                            </div>
                            <a href="#" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- ./col -->
                    <div class="col-lg-3 col-6">
                        <!-- small box -->
                        <div class="small-box bg-danger">
                            <div class="inner">
                                <h3>{{convertToBMK($totalUsers)}}</h3>
                                <p>System Users</p>
                            </div>
                            <div class="icon">
                                <i class="ion ion-pie-graph"></i>
                            </div>
                            <a href="#" class="small-box-footer">More info <i class="fas fa-arrow-circle-right"></i></a>
                        </div>
                    </div>
                    <!-- ./col -->
                </div>
                <!-- /.row -->
                <div class="row">
                    <section class="col-md-6 h-100 my-2 connectedSortable ui-sortable">
                        <!-- Custom tabs (Charts with tabs)-->
                        <div class="card h-100">

                            <div class="card-body">
                                <h5>
                                    <i class="fas fa-chart-pie mr-1"></i>
                                    Small groups
                                </h5>
                                <div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="start_date">Start Date</label>
                                                <input type="date" class="form-control" id="start_date"/>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="end_date">End Date</label>
                                                <input type="date" class="form-control" id="end_date"/>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="mb-3">
                                                <label for="offering_type_id">Offering Type</label>
                                                <select class="form-control" id="offering_type_id">
                                                    <option value="">All</option>
                                                    @foreach(\App\OfferingType::query()->latest()->get() as $offeringType)
                                                        <option
                                                            value="{{$offeringType->id}}">{{$offeringType->OfferingName}}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div id="small_groups_chart"></div>
                            </div>
                        </div>
                        <!-- /.card -->

                    </section>
                    <section class="col-md-6 h-100 my-2">
                        <!-- Custom tabs (Charts with tabs)-->

                        <div class=" card h-100 card-body">

                            <div id="small_groups_status_bar_chart" style="min-height: 450px;"></div>
                        </div>

                        <!-- /.card -->

                    </section>
                </div>
                <!-- Main row -->
                <div class="row">
                    <!-- Left col -->
                    <section class="col-md-8 connectedSortable ui-sortable">
                        <!-- Custom tabs (Charts with tabs)-->
                        <div class="card">
                            <div class="card-header ui-sortable-handle" style="cursor: move;">
                                <h3 class="card-title">
                                    <i class="fas fa-chart-pie mr-1"></i>
                                    Total Offerings by Types
                                </h3>
                                <div class="card-tools">
                                </div>
                            </div>
                            <div class="card-body">
                                <div id="revenue-chart-canvas"></div>
                            </div>
                        </div>
                        <!-- /.card -->

                    </section>
                    <!-- /.Left col -->
                    <!-- Left col -->
                    <section class="col-md-4 connectedSortable ui-sortable">
                        <!-- Custom tabs (Charts with tabs)-->
                        <div class="card">
                            <div class="card-header ui-sortable-handle" style="cursor: move;">
                                <h3 class="card-title">
                                    <i class="fas fa-chart-pie mr-1"></i>
                                    Total Offerings
                                </h3>
                                <div class="card-tools">
                                </div>
                            </div>
                            <div class="card-body">
                                <div id="sales-chart-canvas"></div>
                            </div>
                        </div>
                        <!-- /.card -->

                    </section>
                    <!-- /.Left col -->

                </div>
                <!-- /.row (main row) -->
            </div><!-- /.container-fluid -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

    <!-- Control Sidebar -->
@endsection


@section("script")
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script src="{{asset('js/dashboard.js')}}"></script>
    <script>
        $(function () {
            'use strict'
            $('.connectedSortable .card-header').css('cursor', 'move')
            const collect = {!! $collect !!};

            const names = collect.map(c => c.name);

            const colors = collect.map(c => c.color);

            const series = collect.map(c => c.data.map(d => d.totalAmount));


            let labels = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
            const salesChartData = {
                labels: labels,
                series: [
                    {
                        name: names[0],
                        data: series[0],
                        color: "#00E396"
                    }, {
                        name: names[1],
                        data: series[1],
                        color: "#E74C3C"
                    }
                ]
            };

            const salesChartOptions = {
                chart: {
                    type: 'bar',
                    height: '350px',
                    stacked: false,
                    toolbar: {
                        show: true,
                    },
                    fontFamily: 'Inter', // Inherit font family for the main chart
                    title: {
                        text: 'Total Monthly Offerings',
                        align: 'left'
                    }
                },
                plotOptions: {
                    bar: {
                        horizontal: false,
                        dataLabels: {
                            position: 'top',
                        },
                    },
                },
                dataLabels: {
                    enabled: false, // You can change this to 'true' to show data labels
                    formatter: function (val) {
                        return Number(val).toLocaleString();
                    },
                    style: {
                        colors: ['#fff'],
                        fontWeight: 'bold'
                    }
                },
                stroke: {
                    show: true,
                    width: 1,
                    colors: ['#fff']
                },
                legend: {
                    show: true,
                },
                series: salesChartData.series,

                xaxis: {
                    categories: salesChartData.labels,
                    labels: {
                        style: {
                            fontSize: '12px',
                            fontWeight: 500
                        }
                    },
                    axisBorder: {
                        show: false,
                    },
                    axisTicks: {
                        show: false,
                    },
                },
                yaxis: {
                    labels: {
                        formatter: function (value) {
                            return Number(value).toLocaleString();
                        },
                        style: {
                            fontSize: '12px'
                        }
                    },
                    axisBorder: {
                        show: false,
                    },
                    axisTicks: {
                        show: false,
                    },
                },
                tooltip: {
                    y: {
                        formatter: function (value) {
                            return Number(value).toLocaleString();
                        }
                    },
                    shared: true,
                    intersect: false
                },
                grid: {
                    show: true,
                    borderColor: '#90A4AE',
                    strokeDashArray: 0,
                    position: 'back',
                    xaxis: {
                        lines: {
                            show: false
                        }
                    },
                    yaxis: {
                        lines: {
                            show: true
                        }
                    },
                },
                responsive: [{
                    breakpoint: 480,
                    options: {
                        legend: {
                            position: 'bottom'
                        }
                    }
                }]
            };

            const salesChartContainer = document.querySelector("#revenue-chart-canvas");
            const salesChart = new ApexCharts(salesChartContainer, salesChartOptions);
            salesChart.render();

            // Total Offerings chart

            const pieData = {
                labels: [
                    @foreach($collect2 as $c)
                        "{{$c['name']}}",
                    @endforeach
                ],
                series: [
                    @foreach($collect2 as $c)
                        {{$c['sum']}},
                    @endforeach
                ],
                colors: [
                    @foreach($collect2 as $c)
                        "{{$c['color']}}",
                    @endforeach
                ]
            };
            const pieOptions = {
                chart: {
                    type: 'donut',
                    height: 'auto', // Adjust as needed
                    // width: '100%', // If you need to control width
                },
                legend: {
                    show: false, // Initially hidden as in your Chart.js config
                },
                labels: pieData.labels,
                series: pieData.series,
                colors: pieData.colors,
                tooltip: {
                    y: {
                        formatter: function (value) {
                            return Number(value).toLocaleString(); // Format the value with locale-specific formatting
                            // You can customize the formatting further if needed:
                            // return Number(value).toLocaleString('en-US', { style: 'decimal', useGrouping: true });
                        }
                    },
                    // Optional: Format the label in the tooltip as well
                    // x: {
                    //     formatter: function (value) {
                    //         return value;
                    //     }
                    // }
                },
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 200
                        },
                        legend: {
                            position: 'bottom'
                        }
                    }
                }]
            };

            const pieChartContainer = document.querySelector("#sales-chart-canvas");
            const pieChart = new ApexCharts(pieChartContainer, pieOptions);
            pieChart.render();

            const chartContainer = document.querySelector("#small_groups_chart");
            let smallGroupsChart; // Declare the chart variable

// Function to simulate fetching new data
            function fetchData() {
                $.ajax({
                    url: `{{ route('dashboard.prepare-pie-data') }}?start_date=${$("#start_date").val()}&end_date=${$("#end_date").val()}&offering_type_id=${$("#offering_type_id").val()}`, // Use template literals for route
                    type: "GET",
                    success: function (response) {

                        if (response.labels.length === 0) {
                            // Display "No Data Available"
                            // Clear the chart container
                            chartContainer.innerHTML = "<div style='text-align: center; color: #999; font-size: 16px; padding: 20px;'>No Data Available</div>";
                            // If a chart instance exists, destroy it
                            if (smallGroupsChart) {
                                smallGroupsChart.destroy();
                            }
                        } else {
                            // Prepare ApexCharts options
                            const options = {
                                series: response.datasets[0].data.map(Number), // Ensure data is numeric
                                labels: response.labels,
                                chart: {
                                    type: "pie",
                                    height: "350px", // Adjust as needed, or use percentages
                                    // width: '100%', // If you want to control width
                                    toolbar: {
                                        show: false, // Hide the toolbar
                                    },
                                },
                                colors: response.datasets[0].backgroundColor, // Use background colors from response
                                // You might need to adapt your generateDynamicColors/2 functions for ApexCharts if they are specific to Chart.js
                                // You can also define a static color array here if needed
                                legend: {
                                    position: "bottom",
                                },
                                tooltip: {
                                    y: {
                                        formatter: function (value) {
                                            return Number(value).toLocaleString(); // Format the 'y' value in the tooltip
                                        }
                                    }
                                },
                                dataLabels: {
                                    enabled: true
                                },
                                responsive: [
                                    {
                                        breakpoint: 480,
                                        options: {
                                            chart: {
                                                width: 200,
                                            },
                                            legend: {
                                                position: "bottom",
                                            },
                                        },
                                    },
                                ],
                            };

                            // If a chart instance exists, destroy it before creating a new one
                            if (smallGroupsChart) {
                                smallGroupsChart.destroy();
                            }

                            // Create and render the ApexCharts chart
                            smallGroupsChart = new ApexCharts(chartContainer, options);
                            smallGroupsChart.render();
                        }
                    },
                    error: function (xhr, status, error) {
                        console.error("Error fetching data:", error);
                        // Optionally display an error message on the page
                    },
                });
            }

            fetchData();

            $("#start_date, #end_date, #offering_type_id").change(function () {
                fetchData();
            });


            function fetchBarChartData() {

                $.ajax({
                    url: `{{ route('dashboard.prepare-bar-chart-data') }}`,
                    type: "GET",
                    success: function (data) {
                        const options = {
                            series: [
                                {
                                    name: 'Active Members',
                                    data: data.datasets[0].data.map(Number), // Ensure data is numeric
                                },
                                {
                                    name: 'Inactive Members',
                                    data: data.datasets[1].data.map(Number), // Ensure data is numeric
                                },
                            ],
                            chart: {
                                type: 'bar',
                                height: '100%', // Adjust as needed, or use percentages
                                stacked: false, // If you want separate bars
                                toolbar: {
                                    show: true,
                                },
                                fontFamily: 'Inter', // Inherit font family for the main chart
                            },
                            plotOptions: {
                                bar: {
                                    horizontal: true,
                                    dataLabels: {
                                        position: 'top',
                                    },
                                }
                            },
                            dataLabels: {
                                enabled: false,
                                offsetX: -6,
                                style: {
                                    fontSize: '12px',
                                    colors: ['#012834']
                                }
                            },
                            stroke: {
                                show: true,
                                width: 1,
                                colors: ['#fff']
                            },
                            tooltip: {
                                shared: true,
                                intersect: false
                            },
                            xaxis: {
                                categories: data.labels,
                                title: {
                                    text: 'Number of Members',
                                },
                            },
                            yaxis: {
                                title: {
                                    text: 'Small Group',
                                },
                            },
                            legend: {
                                position: 'bottom',
                                horizontalAlign: 'center',
                            },
                            title: {
                                text: 'Active and Inactive Members per Small Group',
                                align: 'left',
                            },
                            fill: {
                                opacity: 1
                            },
                            colors: ['#00E396', 'rgba(229,0,0,0.8)'],
                        };

                        const apexCahart = new ApexCharts(document.querySelector("#small_groups_status_bar_chart"), options);
                        apexCahart.render();
                    },
                    error: function (xhr, status, error) {

                    }
                });

            }

            fetchBarChartData();


        })
    </script>
@endsection

