<nav {{ $attributes->class(['main-header navbar navbar-expand-md navbar-light navbar-white']) }}>
    <div class="container">
        <a href="/" class="navbar-brand">
            <span class="brand-text font-weight-light">
                {{config('app.name')}}
            </span>
        </a>

        <button class="navbar-toggler order-1" type="button" data-toggle="collapse" data-target="#navbarCollapse"
                aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>

        <div class="collapse navbar-collapse order-3" id="navbarCollapse">
            <!-- Left navbar links -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a href="/" class="nav-link">Home</a>
                </li>


                @if(auth()->user()->small_group_id)
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
                           data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Memberships
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            @can("Manage Membership")
                                <a class="dropdown-item" href="{{route('Membership.index')}}">Membership</a>
                            @endcan
                            <a class="dropdown-item" href="{{route('small.grp.members.index')}}">Small Group
                                Members</a>
                        </div>
                    </li>
                @else
                    @can("Manage Membership")
                        <li class="nav-item">
                            <a href="{{route('Membership.index')}}" class="nav-link">Membership</a>
                        </li>

                    @endcan
                @endif


                {{--       @can("View Visit History")
                           <li class="nav-item">
                               <a href="{{route('visit.history')}}" class="nav-link">Visit History</a>
                           </li>
                       @endcan
   --}}
                @if(auth()->user()->is_admin)
                    <li class="nav-item">
                        <a href="{{route('companies.index')}}" class="nav-link">Companies</a>
                    </li>
                @endif
                {{--//             report--}}
                @canany(["Manage Tithe","Manage Offering Types"])
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
                           data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Finance
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            @can("Manage Offering Types")
                                <a class="dropdown-item" href="{{route('offering.type.create')}}">Offering Type</a>
                            @endcan
                            @can("Manage Tithe")
                                <a class="dropdown-item" href="{{route('base-offering-tithe.index')}}">Tithe & Offering</a>
                                <a class="dropdown-item" href="{{route('tithe.and.offering.summary.report')}}">Offering
                                    Summary Report</a>
                                <a class="dropdown-item" href="{{route('tithe.and.offering.detailed.report')}}">Offering
                                    detailed report</a>
                            @endcan

                            @can("Manage Expenses")
                                <a class="dropdown-item" href="{{route('expenses.index')}}">Expenses</a>
                            @endcan

                            @can("Manage Expense Category")
                                <a class="dropdown-item" href="{{route('expensesCategory.index')}}">Expense
                                    Category</a>
                            @endcan

                        </div>
                    </li>
                @endcanany

                {{--//             report--}}

                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
                       data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        Reports
                    </a>
                    <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                        <a class="dropdown-item" href="{{route('reports.report-offering-tithe')}}">
                            Tithe and Offering
                        </a>
                        @can("Manage Report Definition")
                            <a class="dropdown-item" href="{{route('report.definition.create')}}">Report
                                Definition
                            </a>
                        @endcan

                        @can("Manage Reporting Data")
                            @if(auth()->user()->small_group_id)
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="{{route('reporting.data.create')}}">Report
                                    Submissions</a>
                            @endif
                        @endcan
                    </div>
                </li>

                {{--//             report--}}
                @canany(["Manage Users","Manage Small Groups","Manage Payment Options"])
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button"
                           data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            Settings
                        </a>
                        <div class="dropdown-menu" aria-labelledby="navbarDropdown">
                            @can("Manage Payment Options")
                                <a class="dropdown-item" href="{{route('payment.option.create')}}">Payment
                                    Options</a>
                            @endcan
                            @can("Manage Small Groups")
                                <a class="dropdown-item" href="{{route('smallGroup.index')}}">Small Groups</a>
                            @endcan
                            @can("Manage Users")
                                <a class="dropdown-item" href="{{route('get.users')}}">Users</a>
                            @endcan
                        </div>
                    </li>
                @endcanany


            </ul>
            <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                @csrf
            </form>
        </div>

        <!-- Right navbar links -->
        <ul class="order-1 order-md-3 navbar-nav navbar-no-expand ml-auto">
            <!-- Messages Dropdown Menu -->
            <!-- Notifications Dropdown Menu -->
            <li class="nav-item">
                <a href="{{route("logout")}}" onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();"
                   class="nav-link"><span class="fa fa-sign-out-alt"></span>Sign out</a>
            </li>
        </ul>
    </div>
</nav>
