

@extends("master")
@section("title",$admin->username??"")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark"> Companies </h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Layout</a></li>
                            <li class="breadcrumb-item active">Top Navigation</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                <div class="float-right">
                                    <a href="#" class="btn btn-success btn-sm btn-create"><span class="fa fa-user-plus"></span> New Company</a></div>

                            </div>
                            <div class="card-body">
                                <table class="table table-striped table-hover">
                                    <thead>
                                    <tr>
                                        <th style="width: 10px">#</th>
                                        <th>Code</th>
                                        <th>Names</th>
                                        <th>Address</th>
                                        <th>Email</th>
                                        <th>Date</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($list as $key=>$item)

                                        <tr >
                                            <td>{{++$key}}</td>
                                            <td>{{$item->code}}</td>
                                            <td>{{$item->name}}</td>
                                            <td>{{$item->address}}</td>
                                            <td>{{$item->email}}</td>
                                            <td>
                                                {{$item->created_at}}
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="card-footer clearfix">
                                {{$list->links()}}
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>

    <div class="modal fade" id="modal-default">
        <div class="modal-dialog">
            <form action="{{route("addCompany")}}" method="post">

                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Add new Company</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        @csrf
                        <div class="form-group">
                            <label for="name">Company name</label>
                            <input type="text" class="form-control" id="name" placeholder="Company name" name="name" required>
                        </div>
                        <div class="form-group">
                            <label for="tin">Company tin</label>
                            <input type="text" class="form-control" id="tin" placeholder="Company tin" name="tin" required>
                        </div>
                        <div class="form-group">
                            <label for="address">Company address</label>
                            <input type="text" class="form-control" id="address" placeholder="Company address" name="address" required>
                        </div>
                        <div class="form-group">
                            <label for="email">Company email</label>
                            <input type="text" class="form-control" id="email" placeholder="Company email" name="email" required>
                        </div>
                        <div class="form-group">
                            <label for="password">Company password</label>
                            <input type="password" class="form-control" id="password" placeholder="Company password" name="password" required>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="submit" class="btn btn-primary">Save changes</button>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->
    <!-- /.content-wrapper -->
    <script>
        $(function () {
          $(".btn-create").click(function (e) {
              $("#modal-default").modal("show");
          });
        })
    </script>
    <!-- Control Sidebar -->
@endsection

