

@extends("master")
@section("title",auth()->user()->name??"")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark"> Small Groups </h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Layout</a></li>
                            <li class="breadcrumb-item active">Top Navigation</li>
                        </ol>

                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                {{--                                <div class="float-right">--}}
                                {{--                                    <a href="#" class="btn btn-success btn-sm btn-create">--}}
                                {{--                                        <span class="fa fa-user-plus"></span> New Payment Option</a>--}}
                                {{--                                </div>--}}
                                <div class="card-toolbar">
                                    <!-- Button trigger modal-->
                                    <button type="button" class="btn btn-success btn-sm btn-create float-right" data-toggle="modal"
                                            data-target="#exampleModalLong">
                                        <span class=""></span>
                                        Add New Group
                                    </button>
                                    <!-- Modal-->
                                </div>
                            </div>


                            <div class="card-body">
                                <table class="table table-striped table-hover data-table">
                                    <thead>
                                    <tr>
                                        <th style="width: 10px">#</th>
                                        <th>Group Name</th>
                                        <th>Group Leader</th>
                                        <th>Phone Number</th>
                                        <th>Description</th>
                                        <th></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($groups as $key=>$group)

                                        <tr >
                                            <td>{{++$key}}</td>
                                            <td>{{$group->group_name}}</td>
                                            <td>{{$group->group_leader}}</td>
                                            <td>{{$group->leader_phone_number}}</td>
                                            <td>{{$group->description}}</td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="#"  data-date=""
                                                       data-id="{{$group->id}}"
                                                       data-name="{{$group->group_name}}"
                                                       data-leader="{{$group->group_leader}}"
                                                       data-phone-number="{{$group->leader_phone_number}}"
                                                       data-description="{{$group->description}}"
                                                       class="btn btn-primary js-edit"><span class="fa fa-edit"></span> </a>
                                                    <a href="{{route('smallGroup.delete',$group->id)}}" class="btn btn-danger js-delete"><span
                                                            class="fa fa-trash"></span> </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="card-footer clearfix">
                                {{--                                {{$list->links()}}--}}
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>

    <div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form action="{{route('smallGroup.store')}}" method="post" id="submissionForm" class="submissionForm" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Add Small Group</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="form-group">
                            <label for="GroupName">Group Name</label>
                            <input type="text" id="GroupName" name="GroupName" class="form-control"
                                   required/>
                        </div>

                        <div class="form-group">
                            <label for="GroupLeader">Group Leader</label>
                            <input type="text" id="GroupLeader" name="GroupLeader" class="form-control"
                                   required/>
                        </div>

                        <div class="form-group">
                            <label for="PhoneNumber"> Phone Number</label>
                            <input type="text" id="PhoneNumber" name="PhoneNumber" class="form-control"
                                   required/>
                        </div>

                        <div class="form-group">
                            <label for="GroupDesc"> Group Description</label>
                            <textarea type="text" id="GroupDesc" name="GroupDesc" class="form-control"
                                      required></textarea>
                        </div>


                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="modalUpdate" data-backdrop="static" tabindex="-1" role="dialog"
         aria-labelledby="staticBackdrop" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{route('smallGroup.update')}}" method="post" id="submissionFormEdit" class="submissionForm" enctype="multipart/form-data">
                @csrf {{method_field('PUT')}}
                <input type="hidden" value="0"  id="SmallGroupId" name="SmallGroupId">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Edit Small Group</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">



                        <div class="form-group">
                            <label for="GroupName">Group Name</label>
{{--                            @foreach(App\Small_group::all() as $g)--}}
                            <input type="text" id="edit-group-name" name="GroupName" class="form-control"
                                   required/>
{{--                            @endforeach--}}
                        </div>


                        <div class="form-group">
                            <label for="GroupLeader">Group Leader</label>
                            <input type="text" id="edit-group-leader" name="GroupLeader" class="form-control"
                                   required/>
                        </div>

                        <div class="form-group">
                            <label for="PhoneNumber"> Phone Number</label>
                            <input type="text" id="edit-phone-number" value="" name="PhoneNumber" class="form-control"
                                   required/>
                        </div>

                        <div class="form-group">
                            <label for="GroupDesc"> Group Description</label>
                            <textarea type="text" id="edit-group-desc" name="GroupDesc" class="form-control"
                                      required></textarea>

                        </div>


                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
    </div>
    <!-- /.modal -->
    <!-- /.content-wrapper -->
    <script>
        $(function () {
            $(".btn-create").click(function (e) {
                $("#modal-default").modal("show");
            });
        })
    </script>
    <!-- Control Sidebar -->
@endsection

@section("script")
    <!-- Laravel Javascript Validation -->
    {{--    <script src="https://unpkg.com/sweetalert2@7.18.0/dist/sweetalert2.all.js"></script>--}}
    {{--    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>--}}
    {{--    {!! JsValidator::formRequest('App\Http\Requests\ValidateManufacture', '.submissionForm'); !!}--}}
    <script>

        $(document).ready(function() {
            $("#submissionForm").validate();
            $("#submissionFormEdit").validate();
            $(document).on('click', '.js-edit', function (e) {
                console.log('clicked');
                e.preventDefault();
                $("#modalUpdate").modal('show');
                console.log($(this).data('id'));
                console.log($(this).data('name'));
                console.log($(this).data('leader'));
                var url = $(this).data('url');
                $("#SmallGroupId").val($(this).data('id'));
                $("#edit-group-name").val($(this).data('name'));
                $("#edit-group-leader").val($(this).data('leader'));
                $("#edit-phone-number").val($(this).data('phone-number'));
                $("#edit-group-desc").val($(this).data('description'));
                $('#submissionFormEdit').attr('action', url);

            });
            $(document).on('click', '.js-delete', function (e) {
                // console.log('deleted');
                e.preventDefault();
                var href = this.href;
                Swal.fire({
                    title: "Are you sure?",
                    text: "Delete this Offering Type ?",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Yes, delete it!",
                    cancelButtonText: "No, cancel!",
                    reverseButtons: true
                }).then((willDelete) => {
                    if (willDelete.value) {
                        window.location = href;
                    } else {
                        //swal("Your imaginary file is safe!");
                    }
                });
            });

            $('#exampleModal').on('hidden.bs.modal', function (e) {
                $('#SmallGroupId').val(0);
            });
        } );



    </script>

@endsection


