
@extends("master")
@section("title",$company->name??"")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark"> Small Group Members </h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Layout</a></li>
                            <li class="breadcrumb-item active">Top Navigation</li>
                        </ol>
                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                <div class="card-title"><span>{{auth()->user()->smallGroup->group_name??""}}</span></div>
{{--                                <div class="float-right">--}}
{{--                                    <a href="#" class="btn btn-success btn-sm btn-create"><span class="fas fa-user-plus"></span> New Member</a>--}}
{{--                                </div>--}}

                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-striped table-hover data-table">
                                        <thead>
                                        <tr>
                                            <th style="width: 10px">#</th>


                                            <th>FirstName</th>
                                            <th>LastName</th>
                                            <th>Phone No</th>
                                            <th>Small Group</th>
                                            <th>Category</th>
                                            <th>Action</th>

                                        </tr>
                                        </thead>
                                        <tbody>
                                        @foreach($members as $key=>$member)

                                            <tr >
                                                <td>{{++$key}}</td>
                                                <td>{{$member->firstname}}</td>
                                                <td>{{$member->lastname}}</td>
                                                <td>{{$member->phone_number}}</td>
                                                <td>{{$member->smallgroups->group_name??''}}</td>
                                                {{--                                            <td>{{$member->sectors->name}}</td>--}}
                                                {{--                                            <td>{{$member->cells->name}}</td>--}}
                                                {{--                                            <td>{{$member->villages->name}}</td>--}}
                                                <td>{{$member->categories->categoryName??''}}</td>
                                                {{--                                            <td>{{$member->statuses->statusName}}</td>--}}
                                                {{--                                            <td>{{$member->church_register_page}}</td>--}}
                                                {{--                                            <td>{{$member->smallgroups->group_name}}</td>--}}
                                                <td>
                                                    <a href="#"
                                                       data-firstname="{{$member->firstname}}"
                                                       data-id="{{$member->id}}"
                                                       data-lastname="{{$member->lastname}}"
                                                       data-phone="{{$member->phone_number}}"
                                                       data-district="{{$member->district_id}}"
                                                       data-sector="{{$member->sector_id}}"
                                                       data-cell="{{$member->cell_id}}"
                                                       data-village="{{$member->village_id}}"
                                                       data-category="{{$member->category_id}}"
                                                       data-status="{{$member->status_id}}"
                                                       data-small="{{$member->small_group_id}}"
                                                       data-marital="{{$member->marital_status}}"
                                                       data-employment="{{$member->employment_status}}"
                                                       class="btn btn-primary btn-edit btn-sm" ><span><i class="far fa-edit"></i></span></a>
                                                 </td>


                                            </tr>
                                        @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="card-footer clearfix">
                                {{--                                {{$members->links()}}--}}
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>

    <div class="modal fade" id="add-member-modal">
        <div class="modal-dialog modal-lg" style="width: 1000px">
            <form action="{{route("Membership.store")}}" method="post" id="submitForm">

                <div class="modal-content justify-content-around">
                    <div class="modal-header ">
                        <h4 class="modal-title text-center">Edit Member information</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>




                    <div class="modal-body justify-content-center modal-lg" >
                        <input type="hidden" name="id" id="member_id" value="0">
                        <input type="hidden" name="from_small" value="1">
                        @csrf

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="member_firstname">FirstName</label>
                                    <input type="text" class="form-control" readonly id="member_firstname" placeholder="Firstname" name="member_firstname" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="member_lastname">LastName</label>
                                    <input type="text" class="form-control" readonly id="member_lastname" placeholder="Lastname" name="member_lastname" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="member_district">District</label>
                                    <select class="form-control" name="member_district" id="member_district">
                                        <option value="">Select District</option>
                                        @foreach(App\District::all() as $district)
                                            <option value="{{$district->id}}">{{$district->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="member_sector">Sector</label>
                                    <select class="form-control" name="member_sector" id="member_sector">
                                        <option value="">Select Sector</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="member_cell">Cell</label>
                                    <select class="form-control" name="member_cell" id="member_cell">
                                        <option value="">Select Cell</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="member_village">Village</label>
                                    <select class="form-control" name="member_village" id="member_village">
                                        <option value="">Select Village</option>
                                    </select>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="member_phone">Phone Number</label>
                                    <input type="text" class="form-control" id="member_phone" placeholder="Phone Number" name="member_phone">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="church_register_page">Book Page</label>
                                    <input type="number" class="form-control" readonly id="church_register_page" placeholder="Book Page" name="church_register_page">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="membership_date">Membership date</label>
                                    <input type="date" class="form-control" readonly id="membership_date" placeholder="Membership date" name="membership_date">
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">

                                <div class="form-group">
                                    <label for="member_category">Category</label>
                                    {{--                            <input type="text" class="form-control" id="member_category" placeholder="Category" name="member_category" required>--}}
                                    <select class="form-control" name="member_category" id="member_category" disabled required>

                                        <option value="">Select Category</option>
                                        @foreach(App\Category::all() as $category)
                                            <option value="{{$category->id}}">{{$category->categoryName}}</option>
                                        @endforeach

                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">

                                <div class="form-group">
                                    <label for="member_status">Status</label>

                                    <select class="form-control" name="member_status" id="member_status" required>
                                        <option value="">Select Status</option>
                                        @foreach(App\Status::all() as $mystatus)
                                            <option value="{{$mystatus->id}}">{{$mystatus->statusName}}</option>
                                        @endforeach
                                    </select>
                                </div>

                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="member_small_group">Small Group</label>
                                    <select class="form-control" name="member_small_group" id="member_small_group" disabled>
                                        <option value="">Select Small Group</option>
                                        @foreach(App\Small_group::query()->where("company_id","=",auth()->user()->company_id)->get() as $smallgroup)
                                            <option value="{{$smallgroup->id}}">{{$smallgroup->group_name}}</option>
                                        @endforeach
                                    </select>
                                </div>


                            </div>
                        </div>

                        <div class="row">

                            <div class="col-md-4">

                                <div class="form-group">
                                    <label for="employment_status">Employment Status</label>
                                    <select class="form-control" name="employment_status" id="employment_status">
                                        <option value="">-- select --</option>
                                        <option value="Full Time job">Full Time job</option>
                                        <option value="Part Time job">Part Time job</option>
                                        <option value="Unemployed">Unemployed</option>
                                    </select>
                                </div>


                            </div>
                            <div class="col-md-4">

                                <div class="form-group">
                                    <label for="marital_status">Marital Status</label>
                                    <select class="form-control" name="marital_status" id="marital_status">
                                        <option value="">-- select --</option>
                                        <option value="Single">Single</option>
                                        <option value="Married">Married</option>
                                        <option value="Widow/Widower">Widow/Widower</option>
                                        <option value="Divorced">Divorced</option>
                                    </select>
                                </div>


                            </div>

                        </div>

                    </div>
                    <div class="modal-footer justify-content-end">
                        @include('partial._modal_footer_buttons')
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <!-- /.modal -->


    <!-- /.content-wrapper -->


@endsection


@section("script")

    <script>

        let loadSectors = function (districtId, selectedId = null) {
            $.ajax({
                url: '/api/sectors/' + districtId+'/district',
                type: 'GET',
                success: function (data) {
                    let $sectorId = $('#member_sector');
                    $sectorId.empty();
                    $sectorId.append('<option value="">Select sector</option>');
                    $.each(data, function (key, value) {
                        $sectorId.append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                    $sectorId.val(selectedId);
                },
                error: function (data) {
                    swal.fire({
                        toast: true,
                        position: 'top-end',
                        title: "Something went wrong!",
                        icon: "error",
                        timer: 3000,
                        showConfirmButton: false,
                        timerProgressBar: true
                    });
                },
            });
        };

        let loadCells = function (sectorId, selectedId = null) {
            $.ajax({
                url: '/api/cells/' + sectorId+'/sector',
                type: 'GET',
                success: function (data) {
                    let $cellId = $('#member_cell');
                    $cellId.empty();
                    $cellId.append('<option value="">Select cell</option>');
                    $.each(data, function (key, value) {
                        $cellId.append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                    $cellId.val(selectedId);
                },
                error: function (data) {
                    swal.fire({
                        toast: true,
                        position: 'top-end',
                        title: "Something went wrong!",
                        icon: "error",
                        timer: 3000,
                        showConfirmButton: false,
                        timerProgressBar: true
                    });
                },
            });
        };
        let loadVillages = function (cellId, selectedId = null) {
            $.ajax({
                url: '/api/villages/' + cellId + '/cell',
                type: 'GET',
                success: function (data) {
                    let $villageId = $('#member_village');
                    $villageId.empty();
                    $villageId.append('<option value="">Select village</option>');
                    $.each(data, function (key, value) {
                        $villageId.append('<option value="' + value.id + '">' + value.name + '</option>');
                    });
                    $villageId.val(selectedId);
                },
                error: function (data) {
                    swal.fire({
                        toast: true,
                        position: 'top-end',
                        title: "Something went wrong!",
                        icon: "error",
                        timer: 3000,
                        showConfirmButton: false,
                        timerProgressBar: true
                    });
                },
            });
        };


        $(function () {

            $(document).on('click','.btn-delete',function (e) {
                e.preventDefault();
                let hrf = this.href;
                swal.fire({
                    title:"Delete Membership",
                    text:"Are you sure you want to delete this?",
                    showCancelButton:true
                }).then(function (v) {
                    if(v.value){
                        window.location.href = hrf;
                    }
                });
            })

            // on change district , get all sectors by district id
            $('#member_district').on('change', function () {
                let districtId = $(this).val();
                loadSectors(districtId);
            });

            // on change sector , get all cells by sector id
            $('#member_sector').on('change', function () {
                let sectorId = $(this).val();
                loadCells(sectorId);
            });

            // on change cell , get all villages by cell id
            $('#member_cell').on('change', function () {
                let cellId = $(this).val();
                loadVillages(cellId);
            });

            $("#submitForm").validate();
            $(".btn-create").click(function (e) {
                $("#add-member-modal").modal("show");
            });
        })


        $(function () {
            $(document).on('click',".btn-edit",function (e) {
                e.preventDefault();


                $("#add-member-modal").modal("show");
                $("#member_id").val($(this).data('id'));
                $("#member_firstname").val($(this).data('firstname'));
                $("#member_lastname").val($(this).data('lastname'));
                $("#member_district").val($(this).data('district'));
                $("#member_phone").val($(this).data('phone'));
                $("#member_status").val($(this).data('status'));
                $("#member_small_group").val($(this).data('small'));
                $("#member_category").val($(this).data('category'));
                $("#employment_status").val($(this).data('employment'));
                $("#marital_status").val($(this).data('marital'));


                if($(this).data('district')) {
                    loadSectors($(this).data('district'), $(this).data('sector'));
                }
                if($(this).data('sector')) {
                    loadCells($(this).data('sector'), $(this).data('cell'));
                }
                if($(this).data('cell')) {
                    loadVillages($(this).data('cell'), $(this).data('village'));
                }
            });
        });

        $('#add-member-modal').on('hidden.bs.modal', function (e) {
            $('#member_id').val(0);
        });
        {{--$(function () {--}}
        {{--    $(".btn-delete").click(function (e) {--}}
        {{--        $("#deleteModal{{$member->id}}").modal("show");--}}
        {{--    });--}}
        {{--});--}}



    </script>
@endsection

