

@extends("master")
@section("title",auth()->user()->name??"")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark"> Expenses </h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Layout</a></li>
                            <li class="breadcrumb-item active">Top Navigation</li>
                        </ol>

                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card card-primary card-outline">
                            <div class="card-header">

                                <div class="card-title">
                                    <form action="" method="get">
                                        <div class="form-inline">
                                            <div class="form-group">
                                                <input type="date" id="start-date" title="Start date" value="{{request("start_date")}}" name="start_date" class="form-control form-control-sm" placeholder="Start date">
                                            </div>
                                            <div class="form-group ml-3">
                                                <input type="date" id="end-date" title="End date" value="{{request("end_date")}}"  name="end_date" class="form-control form-control-sm" placeholder="End date">
                                            </div>
                                            <div class="form-group ml-3">
                                                <button class="btn btn-primary btn-sm">Filter Expenses</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                                <div class="card-toolbar">
                                    <!-- Button trigger modal-->
                                    <button type="button" class="btn btn-success btn-sm btn-create float-right" data-toggle="modal"
                                            data-target="#exampleModalLong">
                                        <span class=""></span>
                                        Add New Expense
                                    </button>
                                    <!-- Modal-->
                                </div>
                            </div>


                            <div class="card-body">
                                <table class="table table-striped table-hover data-table">
                                    <thead>
                                    <tr>

                                        <th>Expense Name</th>
                                        <th>Expense Category</th>
                                         <th>Amount</th>
                                        <th>Description</th>
                                        <th>Requested By</th>
                                        <th>Date</th>
                                        <th>Action</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($expenses as $key=>$expense)

                                        <tr >

                                            <td>{{$expense->expense_name}}</td>
                                            <td>{{optional($expense->expenseCat)->category_name}}</td>
                                             <td>{{$expense->amount}}</td>
                                            <td>{{$expense->description}}</td>
                                            <td>{{$expense->requested_by}}</td>
                                            <td>{{$expense->expense_date}}</td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="#"
                                                       data-id="{{$expense->id}}"
                                                       data-expense-name="{{$expense->expense_name}}"
                                                       data-expense-category="{{optional($expense->expenseCat)->id}}"
                                                       data-church="{{optional($expense->churches)->id}}"
                                                       data-amount="{{$expense->amount}}"
                                                       data-description="{{$expense->description}}"
                                                       data-requested-by="{{$expense->requested_by}}"
                                                       data-expense-date="{{$expense->expense_date}}"

                                                       class="btn btn-primary js-edit"><span class="fa fa-edit"></span> </a>
                                                    <a href="{{route('expenses.delete',$expense->id)}}" class="btn btn-danger js-delete"><span
                                                            class="fa fa-trash"></span> </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="card-footer clearfix">
                                {{--                                {{$list->links()}}--}}
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>

    <div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form action="{{route('expenses.store')}}" method="post" id="submissionForm" class="submissionForm" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Add Expense</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="row">
                            <div class="col-md-6"><div class="form-group">
                                    <label for="expenseName">Expense Name</label>
                                    <input type="text" id="expenseName" name="expenseName" class="form-control"
                                           required/>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="expenseCategory">Expense Category</label>
                                    <select class="form-control" name="expenseCategory" id="expenseCategory">
                                        <option value="">Select Expense Category</option>
                                        @foreach(App\ExpenseCategory::all() as $expense)
                                            <option value="{{$expense->id}}">{{$expense->category_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="amount">Amount</label>
                                    <input type="number" id="amount" name="amount" class="form-control"
                                           required/>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="expenseDate">Expense Date</label>
                                    <input type="date" id="expenseDate" name="expenseDate" class="form-control"
                                           required/>
                                </div>
                            </div>
                        </div>



                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="requestedBy">Requested By</label>
                                    <input type="text" id="requestedBy" name="requestedBy" class="form-control"
                                           required/>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="description">Description</label>
                                    <textarea type="text" id="description" name="description" class="form-control"
                                              required></textarea>
                                </div>
                            </div>
                        </div>






                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="modalUpdate" data-backdrop="static" tabindex="-1" role="dialog"
         aria-labelledby="staticBackdrop" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{route('expenses.update')}}" method="post" id="submissionFormEdit" class="submissionForm" enctype="multipart/form-data">
                @csrf {{method_field('PUT')}}
                <input type="hidden" value="0"  id="expenseId" name="expenseId">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Edit Expense</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-expense-name">Expense Name</label>
                                    <input type="text" id="edit-expense-name" name="expenseName" class="form-control"
                                           required/>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-expense-category">Expense Category</label>
                                    <select class="form-control" name="expenseCategory" id="edit-expense-category">
                                        <option value="">Select Expense Category</option>
                                        @foreach(App\ExpenseCategory::all() as $exp)
                                            <option value="{{$exp->id}}">{{$exp->category_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-amount">Amount</label>
                                    <input type="number" id="edit-amount" name="amount" class="form-control"
                                           required/>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-expenseDate">Expense Date</label>
                                    <input type="date" id="edit-expenseDate" name="expenseDate" class="form-control"
                                           required/>
                                </div>
                            </div>
                        </div>


                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-requestedBy">Requested By</label>
                                    <input type="text" id="edit-requestedBy" name="requestedBy" class="form-control"
                                           required/>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="edit-description">Description</label>
                                    <textarea type="text" id="edit-description" name="description" class="form-control"
                                              required></textarea>
                                </div>
                            </div>
                        </div>





                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
    </div>
    <!-- /.modal -->
    <!-- /.content-wrapper -->
    <script>
        $(function () {
            $(".btn-create").click(function (e) {
                $("#modal-default").modal("show");
            });
        })
    </script>
    <!-- Control Sidebar -->
@endsection

@section("script")
    <!-- Laravel Javascript Validation -->
    {{--    <script src="https://unpkg.com/sweetalert2@7.18.0/dist/sweetalert2.all.js"></script>--}}
    {{--    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>--}}
    {{--    {!! JsValidator::formRequest('App\Http\Requests\ValidateManufacture', '.submissionForm'); !!}--}}
    <script>

        {{--$(function () {--}}

        {{--    $('.datatable').DataTable({--}}
        {{--        processing: true,--}}
        {{--        serverSide: true,--}}
        {{--        ajax: "{{ route('expenses.index') }}",--}}
        {{--        columns: [--}}
        {{--            {data: 'id', name: 'expenseId'},--}}
        {{--            {data: 'expense_category_id', name: 'expenseCategory'},--}}
        {{--            {data: 'amount', name: 'amount'},--}}
        {{--            {data: 'description', name: 'description'},--}}
        {{--            {data: 'requested_by', name: 'requestedBy'},--}}
        {{--            {data: 'expense_date', name: 'expenseDate'},--}}
        {{--            {data: 'phone_number', name: 'phone_number'},--}}
        {{--            {--}}
        {{--                data: 'expense_categories.category_name', name: 'expense_categories.category_name', render: function (data) {--}}
        {{--                    return data ?? "";--}}
        {{--                }--}}
        {{--            },--}}
        {{--            {--}}
        {{--                data: 'companies.name', name: 'companies.name', render: function (data) {--}}
        {{--                    return data ?? "";--}}
        {{--                }--}}
        {{--            },--}}
        {{--            {data: 'action', name: 'action', searchable: false, orderable: false},--}}
        {{--        ]--}}
        {{--    });--}}
        {{--});--}}

        $(document).ready(function() {
            $("#submissionForm").validate();
            $("#submissionFormEdit").validate();
            $(document).on('click', '.js-edit', function (e) {
                console.log('clicked');
                e.preventDefault();
                $("#modalUpdate").modal('show');
                console.log($(this).data('id'));
                console.log($(this).data('expense-category'));

                var url = $(this).data('url');
                $("#expenseId").val($(this).data('id'));
                $("#edit-expense-name").val($(this).data('expense-name'));
                $("#edit-expense-category").val($(this).data('expense-category'));
                $("#edit-church").val($(this).data('church'));
                $("#edit-amount").val($(this).data('amount'));
                $("#edit-description").val($(this).data('description'));
                $("#edit-requestedBy").val($(this).data('requested-by'));
                $("#edit-expenseDate").val($(this).data('expense-date'));
                $('#submissionFormEdit').attr('action', url);

            });
            $(document).on('click', '.js-delete', function (e) {
                // console.log('deleted');
                e.preventDefault();
                var href = this.href;
                Swal.fire({
                    title: "Are you sure?",
                    text: "Delete this Offering Type ?",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Yes, delete it!",
                    cancelButtonText: "No, cancel!",
                    reverseButtons: true
                }).then((willDelete) => {
                    if (willDelete.value) {
                        window.location = href;
                    } else {
                        //swal("Your imaginary file is safe!");
                    }
                });
            });

            $('#exampleModal').on('hidden.bs.modal', function (e) {
                $('#expenseId').val(0);
            });
        } );



    </script>

@endsection


