

@extends("master")
@section("title",auth()->user()->name??"")
@section("body")

    <!-- Navbar -->
    <!-- /.navbar -->

    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container">
                <div class="row mb-2">
                    <div class="col-sm-6">
                        <h1 class="m-0 text-dark"> Expense Category </h1>
                    </div><!-- /.col -->
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-right">
                            <li class="breadcrumb-item"><a href="#">Home</a></li>
                            <li class="breadcrumb-item"><a href="#">Layout</a></li>
                            <li class="breadcrumb-item active">Top Navigation</li>
                        </ol>

                    </div><!-- /.col -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content-header -->

        <!-- Main content -->
        <div class="content">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">

                        <div class="card card-primary card-outline">
                            <div class="card-header">
                                {{--                                <div class="float-right">--}}
                                {{--                                    <a href="#" class="btn btn-success btn-sm btn-create">--}}
                                {{--                                        <span class="fa fa-user-plus"></span> New Payment Option</a>--}}
                                {{--                                </div>--}}
                                <div class="card-toolbar">
                                    <!-- Button trigger modal-->
                                    <button type="button" class="btn btn-success btn-sm btn-create float-right" data-toggle="modal"
                                            data-target="#exampleModalLong">
                                        <span class=""></span>
                                        Add New Category
                                    </button>
                                    <!-- Modal-->
                                </div>
                            </div>


                            <div class="card-body">
                                <table class="table table-striped table-hover data-table">
                                    <thead>
                                    <tr>

                                        <th>Category Name</th>
                                        <th>Action</th>

                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($expcats as $key=>$expcat)

                                        <tr >

                                            <td>{{$expcat->category_name}}</td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="#"  data-date=""
                                                       data-id="{{$expcat->id}}"
                                                       data-category-name="{{$expcat->category_name}}"
                                                       data-company-id="{{$expcat->company_id}}"

                                                       class="btn btn-primary js-edit"><span class="fa fa-edit"></span> </a>
                                                    <a href="{{route('expensesCategory.delete',$expcat->id)}}" class="btn btn-danger js-delete"><span
                                                            class="fa fa-trash"></span> </a>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="card-footer clearfix">
                                {{--                                {{$list->links()}}--}}
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <!-- /.col-md-6 -->
                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
        <!-- /.content -->
    </div>

    <div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form action="{{route('expensesCategory.store')}}" method="post" id="submissionForm" class="submissionForm" enctype="multipart/form-data">
                @csrf
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">Add Expense Category</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">

                        <div class="form-group">
                            <label for="categoryName">Category Name</label>
                            <input type="text" id="categoryName" name="categoryName" class="form-control"
                                   required/>
                        </div>

{{--                        <div class="form-group">--}}
{{--                            <label for="church">Church</label>--}}
{{--                            <select class="form-control" name="church" id="church">--}}
{{--                                <option value="">Select Church</option>--}}
{{--                                @foreach(App\Company::all() as $church)--}}
{{--                                    <option value="{{$church->id}}">{{$church->name}}</option>--}}
{{--                                @endforeach--}}
{{--                            </select>--}}
{{--                        </div>--}}


                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Save </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="modal fade" id="modalUpdate" data-backdrop="static" tabindex="-1" role="dialog"
         aria-labelledby="staticBackdrop" aria-hidden="true">
        <div class="modal-dialog">
            <form action="{{route('expensesCategory.update')}}" method="post" id="submissionFormEdit" class="submissionForm" enctype="multipart/form-data">
                @csrf {{method_field('PUT')}}
                <input type="hidden" value="0"  id="expenseCategoryId" name="expenseCategoryId">
                <div class="modal-content">
                    <div class="modal-header">
                        <h4 class="modal-title">Edit Expense Category</h4>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">



                        <div class="form-group">
                            <label for="edit-category-name">Category Name</label>
                            <input type="text" id="edit-category-name" name="categoryName" class="form-control"
                                   required/>
                        </div>


                    </div>
                    <div class="modal-footer">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </div>
                    </div>
                </div>
            </form>
            <!-- /.modal-content -->
        </div>
    </div>
    <!-- /.modal -->
    <!-- /.content-wrapper -->
    <script>
        $(function () {
            $(".btn-create").click(function (e) {
                $("#modal-default").modal("show");
            });
        })
    </script>
    <!-- Control Sidebar -->
@endsection

@section("script")
    <!-- Laravel Javascript Validation -->
    {{--    <script src="https://unpkg.com/sweetalert2@7.18.0/dist/sweetalert2.all.js"></script>--}}
    {{--    <script type="text/javascript" src="{{ asset('vendor/jsvalidation/js/jsvalidation.js')}}"></script>--}}
    {{--    {!! JsValidator::formRequest('App\Http\Requests\ValidateManufacture', '.submissionForm'); !!}--}}
    <script>

        $(document).ready(function() {
            $("#submissionForm").validate();
            $("#submissionFormEdit").validate();
            $(document).on('click', '.js-edit', function (e) {
                console.log('clicked');
                e.preventDefault();
                $("#modalUpdate").modal('show');
                console.log($(this).data('id'));
                console.log($(this).data('category-name'));
                console.log($(this).data('company-id'));

                var url = $(this).data('url');
                $("#expenseCategoryId").val($(this).data('id'));
                $("#edit-category-name").val($(this).data('category-name'));
                $('#submissionFormEdit').attr('action', url);

            });
            $(document).on('click', '.js-delete', function (e) {
                // console.log('deleted');
                e.preventDefault();
                var href = this.href;
                Swal.fire({
                    title: "Are you sure?",
                    text: "Delete this Offering Type ?",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonText: "Yes, delete it!",
                    cancelButtonText: "No, cancel!",
                    reverseButtons: true
                }).then((willDelete) => {
                    if (willDelete.value) {
                        window.location = href;
                    } else {
                        //swal("Your imaginary file is safe!");
                    }
                });
            });

            $('#exampleModal').on('hidden.bs.modal', function (e) {
                $('#expenseCategoryId').val(0);
            });
        } );



    </script>

@endsection


