<?php
function convertToBMK($value)
{
    if (!is_numeric($value)) {
        return $value;
    }
//    e.g 2.4K , 1.2M, 3.5B
    if ($value >= 1000000000) {
        return round($value / 1000000000, 2) . 'B';
    } elseif ($value >= 1000000) {
        return round($value / 1000000, 2) . 'M';
    } elseif ($value >= 1000) {
        return round($value / 1000, 2) . 'K';
    } else {
        return $value;
    }
}
