<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Visit
 *
 * @property mixed  individual_id
 * @property mixed company_id
 * @property mixed temperature
 * @property mixed $vaccination
 * @property mixed $vaccination_code
 * @property int $id
 * @property int $company_id
 * @property int $individual_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property float $temperature
 * @property-read \App\Company $company
 * @property-read \App\Individual $individual
 * @method static \Illuminate\Database\Eloquent\Builder|Visit newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Visit newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Visit query()
 * @method static \Illuminate\Database\Eloquent\Builder|Visit whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Visit whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Visit whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Visit whereIndividualId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Visit whereTemperature($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Visit whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Visit whereVaccination($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Visit whereVaccinationCode($value)
 * @mixin \Eloquent
 */
class Visit extends Model
{
    //
    public function company()
    {
        return $this->belongsTo(Company::class);
    }

    public function individual()
    {
        return $this->belongsTo(Individual::class);
    }
}
