<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Village
 *
 * @property int $id
 * @property int $cell_id
 * @property string $name
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Cell $cell
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Membership> $memberships
 * @property-read int|null $memberships_count
 * @method static \Illuminate\Database\Eloquent\Builder|Village newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Village newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Village query()
 * @method static \Illuminate\Database\Eloquent\Builder|Village whereCellId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Village whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Village whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Village whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Village whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class Village extends Model
{
    //
    public function cell()
    {
        return $this->belongsTo(Cell::class);
    }

    public function memberships()
    {
        return $this->hasMany(Membership::class,'village_id');
    }
}
