<?php

namespace App\View\Components;

use Illuminate\View\Component;
use Illuminate\View\View;

class ReportHeader extends Component
{

    /**
     * @var string
     */
    public $title;

    /**
     * @var string
     */
    public $showExtra;
    /**
     * @var bool
     */
    public $showDate;

    /**
     * Create a new component instance.
     *
     * @param string $title
     * @param bool $showDate
     * @param string $showExtra
     */
    public function __construct(string $title, $showDate = true, $showExtra = "")
    {
        $this->title = $title;
        $this->showDate = $showDate;
        $this->showExtra = $showExtra;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return View|string
     */
    public function render()
    {
        return view('components.report-header');
    }
}
