<?php

namespace App\View\Components;

use Illuminate\View\Component;

class PageHeader extends Component
{
    /**
     * @var string
     */
    public $currentPageTitle;
    /**
     * @var bool
     */
    public $isPrintable = false;

    /**
     * Create a new component instance.
     *
     * @param $currentPageTitle
     * @param bool $isPrintable
     */
    public function __construct($currentPageTitle,$isPrintable = false)
    {
        $this->currentPageTitle = $currentPageTitle;
        $this->isPrintable = $isPrintable;
    }

    /**
     * Get the view / contents that represent the component.
     *
     * @return \Illuminate\View\View|string
     */
    public function render()
    {
        return view('components.page-header');
    }
}
