<?php

namespace App\Traits;

trait HasStatusColor
{

    public function getStatusColorAttribute(): string
    {
        $status = strtolower($this->status);
        return match ($status) {
            strtolower(\App\AppStatus::PENDING), strtolower(\App\AppStatus::DRAFT) => 'warning',
            strtolower(\App\AppStatus::APPROVED) => 'success',
            strtolower(\App\AppStatus::REJECTED) => 'danger',
            default => 'secondary',
        };
    }


}
