<?php

namespace App;

use App\Traits\HasStatusColor;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TitheOfferingBase extends Model
{
    use HasStatusColor;
    protected $appends= ['status_color'];
    const MOMO_UPLOAD = "MOMO Upload";
    const CFMS_UPLOAD = "CFMS Upload";
    const MANUAL_UPLOAD = "Manual Upload";
    const MANUAL_ENTRY = "Manual Entry";

    public static function sources(): array
    {
        return [
            self::MOMO_UPLOAD,
            self::CFMS_UPLOAD,
            self::MANUAL_UPLOAD,
            self::MANUAL_ENTRY
        ];
    }

    public function titheOfferings(): HasMany
    {
        return $this->hasMany(TitheAndOffering::class, 'tithe_offering_base_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class);
    }

    public function canBeDeleted(): bool
    {
        return true;
    }
}
