<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * App\TitheAndOffering
 *
 * @property int $id
 * @property int $CompanyId
 * @property int|null $MemberId
 * @property int $OfferingTypeId
 * @property string $Amount
 * @property int $PaymentOptionId
 * @property string $Date
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property string|null $member_names
 * @property string|null $member_phone
 * @property string|null $txn_id
 * @property string|null $txn_ref
 * @property-read \App\Company $company
 * @property-read \App\Membership|null $member
 * @property-read \App\OfferingType $offering
 * @property-read \App\PaymentOption $payment
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering query()
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering whereAmount($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering whereDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering whereMemberId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering whereMemberNames($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering whereMemberPhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering whereOfferingTypeId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering wherePaymentOptionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering whereTxnId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering whereTxnRef($value)
 * @method static \Illuminate\Database\Eloquent\Builder|TitheAndOffering whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class TitheAndOffering extends Model
{
    protected $casts = [
        'Date' => 'date'
    ];
    protected $guarded = [];


    public function company(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Company::class, 'CompanyId');
    }

    public function member(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Membership::class, 'MemberId');
    }

    public function offering(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(OfferingType::class, 'OfferingTypeId');
    }

    public function payment(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(PaymentOption::class, 'PaymentOptionId');
    }
}
