<?php

namespace App\Services;

use App\TitheAndOffering;
use Illuminate\Support\Facades\DB;

class ReportService
{
    public function titheOfferingBuilder($startDate, $endDate, $offeringTypeId)
    {
        return TitheAndOffering::query()
            ->leftJoin('offering_types as ot', 'tithe_and_offerings.OfferingTypeId', '=', 'ot.id')
            ->leftJoin('memberships as m', 'tithe_and_offerings.MemberId', '=', 'm.id')
            ->leftJoin('small_groups as sg', 'm.small_group_id', '=', 'sg.id')
            ->when(auth()->user()->company_id, function ($query) {
                $query->where('tithe_and_offerings.CompanyId', auth()->user()->company_id);
            })
            ->addSelect([
                DB::raw("COALESCE(sg.group_name, 'Unknown') as group_name"),
                DB::raw("COALESCE(CONCAT(m.firstname, ' ', m.lastname), 'Unknown') as name"),
                DB::raw("COUNT(tithe_and_offerings.id) as offering_count"),
                DB::raw("SUM(tithe_and_offerings.Amount) as total_amount"),
                DB::raw("COALESCE(ot.OfferingName, 'Unknown') as OfferingName")
            ])
            ->when($offeringTypeId, function ($query, $offeringTypeId) {
                $query->where('tithe_and_offerings.OfferingTypeId', $offeringTypeId);
            })
            ->when($startDate, function ($query, $startDate) {
                $query->whereDate('tithe_and_offerings.Date', '>=', $startDate);
            })
            ->when($endDate, function ($query, $endDate) {
                $query->whereDate('tithe_and_offerings.Date', '<=', $endDate);
            })
            ->groupBy('sg.group_name', 'm.id', 'ot.OfferingName')
            ->orderBy('sg.group_name')
            ->orderBy('name');
    }
}
