<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * App\ReportSubmission
 *
 * @property mixed|string $status
 * @property int $id
 * @property int $report_id
 * @property int $submitted_by
 * @property string|null $date
 * @property int|null $month
 * @property int|null $quarter
 * @property int|null $year
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property int|null $small_group_id
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\ReportSubmissionData> $data
 * @property-read int|null $data_count
 * @property-read \App\ReportDefinition $report
 * @property-read \App\User $user
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission query()
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission whereDate($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission whereMonth($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission whereQuarter($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission whereReportId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission whereSmallGroupId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission whereStatus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission whereSubmittedBy($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportSubmission whereYear($value)
 * @mixin \Eloquent
 */
class ReportSubmission extends Model
{
    public function report(){
        return $this->belongsTo(ReportDefinition::class,'report_id');
    }

    public function user(){
        return $this->belongsTo(User::class,"submitted_by");
    }

    public function data(){
        return $this->hasMany(ReportSubmissionData::class,"submission_id");
    }
}
