<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * App\ReportDefinition
 *
 * @property int $id
 * @property int $company_id
 * @property string $report_name
 * @property string $frequency
 * @property int $is_active
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Company $company
 * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\IndicatorDefinition> $indicators
 * @property-read int|null $indicators_count
 * @method static \Illuminate\Database\Eloquent\Builder|ReportDefinition newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ReportDefinition newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|ReportDefinition query()
 * @method static \Illuminate\Database\Eloquent\Builder|ReportDefinition whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportDefinition whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportDefinition whereFrequency($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportDefinition whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportDefinition whereIsActive($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportDefinition whereReportName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|ReportDefinition whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class ReportDefinition extends Model
{
    public function company(): BelongsTo
    {
        return $this->belongsTo(Company::class,'company_id');
    }

    public function indicators(): HasMany
    {
        return $this->hasMany(IndicatorDefinition::class,"report_id");
    }

}
