<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * App\PaymentOption
 *
 * @property int $id
 * @property int $CompanyId
 * @property string $PaymentOption
 * @property int $Is_Active
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Company $company
 * @method static \Illuminate\Database\Eloquent\Builder|PaymentOption newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|PaymentOption newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|PaymentOption query()
 * @method static \Illuminate\Database\Eloquent\Builder|PaymentOption whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PaymentOption whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PaymentOption whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PaymentOption whereIsActive($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PaymentOption wherePaymentOption($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PaymentOption whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class PaymentOption extends Model
{
    use HasFactory;
    public function company(): \Illuminate\Database\Eloquent\Relations\BelongsTo
    {
        return $this->belongsTo(Company::class,'CompanyId');
    }
}
