<?php

namespace App;

use Eloquent;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Company;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Carbon;


/**
 * App\Membership
 *
 * @property int $id
 * @property int $company_id
 * @property string $firstname
 * @property string $lastname
 * @property string|null $phone_number
 * @property string|null $phone_number_2
 * @property int|null $district_id
 * @property int|null $sector_id
 * @property int|null $cell_id
 * @property int|null $village_id
 * @property int|null $category_id
 * @property int|null $status_id
 * @property int|null $church_register_page
 * @property int|null $small_group_id
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property Carbon|null $membership_date
 * @property string|null $origin_church
 * @property string|null $observation
 * @property string|null $employment_status
 * @property string|null $marital_status
 * @property-read Category|null $categories
 * @property-read Cell|null $cells
 * @property-read Company $companies
 * @property-read District|null $districts
 * @property-read Sector|null $sectors
 * @property-read Small_group|null $smallgroups
 * @property-read Status|null $statuses
 * @property-read Village|null $villages
 * @method static Builder|Membership newModelQuery()
 * @method static Builder|Membership newQuery()
 * @method static Builder|Membership query()
 * @method static Builder|Membership whereCategoryId($value)
 * @method static Builder|Membership whereCellId($value)
 * @method static Builder|Membership whereChurchRegisterPage($value)
 * @method static Builder|Membership whereCompanyId($value)
 * @method static Builder|Membership whereCreatedAt($value)
 * @method static Builder|Membership whereDistrictId($value)
 * @method static Builder|Membership whereEmploymentStatus($value)
 * @method static Builder|Membership whereFirstname($value)
 * @method static Builder|Membership whereId($value)
 * @method static Builder|Membership whereLastname($value)
 * @method static Builder|Membership whereMaritalStatus($value)
 * @method static Builder|Membership whereMembershipDate($value)
 * @method static Builder|Membership whereObservation($value)
 * @method static Builder|Membership whereOriginChurch($value)
 * @method static Builder|Membership wherePhoneNumber($value)
 * @method static Builder|Membership wherePhoneNumber2($value)
 * @method static Builder|Membership whereSectorId($value)
 * @method static Builder|Membership whereSmallGroupId($value)
 * @method static Builder|Membership whereStatusId($value)
 * @method static Builder|Membership whereUpdatedAt($value)
 * @method static Builder|Membership whereVillageId($value)
 * @mixin Eloquent
 */
class Membership extends Model
{
    use HasFactory;
    protected $fillable = ['company_id','firstname','lastname','phone_number','district_id','sector_id','village_id','category','status_id','church_register_page','small_group_id'];


    protected $casts = ['membership_date'=>'date'];

    public function companies(){

        return $this->belongsTo(Company::class,'company_id');
    }

    public function districts(){
        return $this->belongsTo(District::class,'district_id');
    }

    public function sectors(){
        return $this->belongsTo(Sector::class,'sector_id');
    }

    public function cells(){
        return $this->belongsTo(Cell::class,'cell_id');
    }

    public function villages(){
        return $this->belongsTo(Village::class,'village_id');
    }

    public function categories(): BelongsTo
    {
        return $this->belongsTo(Category::class,'category_id');
    }


    public function statuses(){
        return $this->belongsTo(Status::class,'status_id');
    }

    public function smallgroups(): BelongsTo
    {
        return $this->belongsTo(Small_group::class,'small_group_id');
    }
    public function smallGroup(): BelongsTo
    {
        return $this->belongsTo(Small_group::class,'small_group_id');
    }



}
