<?php

namespace App\Livewire\Reports;

use App\Services\ReportService;
use Livewire\Attributes\Url;
use Livewire\Component;

class TitheOfferingReport extends Component
{
    #[Url]
    public ?string $startDate;
    #[Url]
    public ?string $endDate;
    #[Url]
    public ?int $offeringTypeId;

    private ReportService $reportService;

    public function __construct()
    {
        $this->startDate = request('startDate', now()->startOfMonth()->format('Y-m-d'));
        $this->endDate = request('endDate', date('Y-m-d'));
        $this->offeringTypeId = request('offeringTypeId', 0);
        $this->reportService = new ReportService();
    }


    public function render(): \Illuminate\Contracts\View\View|\Illuminate\Foundation\Application|\Illuminate\Contracts\View\Factory|\Illuminate\View\View
    {
        $data = $this->reportService->titheOfferingBuilder($this->startDate, $this->endDate, $this->offeringTypeId)->get();
        return view('livewire.reports.tithe-offering-report', compact('data'));
    /*}
        return view('livewire.reports.tithe-offering-report');*/
    }
}
