<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * App\Individual
 *
 * @property mixed  phone
 * @property mixed  names
 * @property mixed  village_id
 * @property mixed password
 * @property int $id
 * @property string $phone
 * @property string $names
 * @property int $village_id
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property string|null $code
 * @property string|null $password
 * @property-read \App\Village $village
 * @method static \Illuminate\Database\Eloquent\Builder|Individual newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Individual newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|Individual query()
 * @method static \Illuminate\Database\Eloquent\Builder|Individual whereCode($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Individual whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Individual whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Individual whereNames($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Individual wherePassword($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Individual wherePhone($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Individual whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|Individual whereVillageId($value)
 * @mixin \Eloquent
 */
class Individual extends Model
{
    //

    protected $guarded = [];

    public function village()
    {
        return $this->belongsTo(Village::class);
    }
}
