<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * App\IndicatorDefinition
 *
 * @property int $id
 * @property int $report_id
 * @property int $company_id
 * @property string $indicator_name
 * @property string $indicator_value_type
 * @property array|null $drop_down_data_source
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 * @property-read \App\Company $company
 * @property-read \App\ReportDefinition $report
 * @method static \Illuminate\Database\Eloquent\Builder|IndicatorDefinition newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|IndicatorDefinition newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|IndicatorDefinition query()
 * @method static \Illuminate\Database\Eloquent\Builder|IndicatorDefinition whereCompanyId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IndicatorDefinition whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IndicatorDefinition whereDropDownDataSource($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IndicatorDefinition whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IndicatorDefinition whereIndicatorName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IndicatorDefinition whereIndicatorValueType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IndicatorDefinition whereReportId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|IndicatorDefinition whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class IndicatorDefinition extends Model
{

    protected $casts = ["drop_down_data_source"=>'array'];

    public function report(){
        return $this->belongsTo(ReportDefinition::class,'report_id');
    }

    public function company(){
        return $this->belongsTo(Company::class,'company_id');
    }
}
