<?php

namespace App\Imports;

use App\Membership;
use App\OfferingType;
use App\TitheAndOffering;
use App\TitheOfferingBase;
use Illuminate\Database\Eloquent\Builder;
use Maatwebsite\Excel\Concerns\OnEachRow;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Row;

class TitheImport implements OnEachRow, WithStartRow
{
    public function __construct($modeId, TitheOfferingBase $offeringBase)
    {
        $this->modeId = $modeId;
        $this->errors = collect();
        $this->offeringBase = $offeringBase;
    }

    public $errors;
    private $modeId;

    private TitheOfferingBase $offeringBase;

    /**
     * @param Row $rowModel
     *
     * @return void|null
     */
    public function onRow(Row $row)
    {
        $row = $row->toArray();
        info(json_encode($row));

        $type = OfferingType::query()->where("CompanyId", "=", auth()->user()->company_id)
            ->where("OfferingName", "=", $row[3])
            ->first();
        $phone = trim($row[2]);

        $phone2 = strlen($phone) == 12 ? substr($phone, 2) : $phone;

        $member = Membership::query()
            ->where("company_id", "=", auth()->user()->company_id)
            ->where(function (Builder $builder) use ($phone2, $phone) {
                $builder->where("phone_number", "=", $phone)
                    ->orWhere("phone_number", "=", $phone2);
            })
            ->first();


        $mId = $member?->id;


        $date = $row[0];
        info($date);
        $this->offeringBase->titheOfferings()->create([
            "Date" => $date,
            "member_names" => $row[1],
            "member_phone" => $phone,
            "OfferingTypeId" => $type->id,
            "Amount" => $row[4],
            "CompanyId" => auth()->user()->company_id,
            "MemberId" => $mId,
            "PaymentOptionId" => $this->modeId
        ]);

    }

    /**
     * @return int
     */
    public function startRow(): int
    {
        return 2;
    }
}
