<?php

namespace App\Imports;

use App\Membership;
use App\OfferingType;
use App\PaymentOption;
use App\TitheAndOffering;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\OnEachRow;
use Maatwebsite\Excel\Concerns\WithChunkReading;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Row;

class MomoTitheImport implements OnEachRow, WithStartRow, WithChunkReading
{
    protected array $tithes = [];

    private Collection $groupedCategories;
    private Collection $categories;

    public function __construct(
        Collection $groupedCategories,
        Collection $categories
    )
    {
        $this->groupedCategories = $groupedCategories;
        $this->categories = $categories;
    }

    private function getMatchedCategory(string $name)
    {
        $name = ucfirst(strtolower(trim($name)));
        foreach ($this->groupedCategories as $index=> $category) {
            $offeringTypeId= $this->categories[$index] ?? null;
            return OfferingType::find($offeringTypeId);
        }
        return null;
    }

    public function onRow(Row $row)
    {
        $row = $row->toArray();

        // Corrected indices based on the column comments
        $id = $row[0] ?? null;                // Column A (index 0)
        $date = $row[2] ?? null;              // Column C (index 2)
        $msisdn = $row[6] ?? null;            // Column G (index 6)

        // Extract phone number from MSISDN if it exists and follows the "FRI:250788305066/MSISDN" format
        if ($msisdn && strpos($msisdn, 'FRI:') === 0) {
            // Remove the 'FRI:' prefix
            $withoutPrefix = substr($msisdn, 4);
            // Split the string by '/' and take the first part, which should be the phone number with country code
            $parts = explode('/', $withoutPrefix);
            $phoneNumber = $parts[0] ?? '';

            // If the number starts with the country code "250", replace it with a "0"
            if (substr($phoneNumber, 0, 3) === '250') {
                $phone = '0' . substr($phoneNumber, 3);
            } else {
                $phone = $phoneNumber;
            }
        } else {
            $phone = null;
        }


        $name = $row[7] ?? null;              // Column H (index 7)
        $offeringType = $row[12] ?? null;     // Column M (index 12)
        $amount = $row[46] ?? 0;              // Column AU (index 46)
        //skip negative amount
        if ($amount > 0) {
            // Append the extracted data into the $tithes array
            $category = ucfirst(strtolower(trim($offeringType)));
            $type = $this->getMatchedCategory($category);
            $member = Membership::query()
                ->where('company_id', auth()->user()->company_id)
                ->where(function (Builder $builder) use ($phone) {
                    $builder->where('phone_number', $phone)
                        ->orWhere('phone_number_2', $phone);
                })
                ->first();

            $mId = $member ? $member->id : null;
            //create date from format liek 1/4/2025 11:27
            $newDate = date_create_from_format('d/m/Y H:i', $date);
            TitheAndOffering::create([
                'Date' => $newDate,
                'member_names' => $name,
                'member_phone' => $phone,
                'OfferingTypeId' => $type->id,
                'Amount' => $amount,
                'CompanyId' => auth()->user()->company_id,
                'MemberId' => $mId,
                'PaymentOptionId' => PaymentOption::query()->first()->id,
                'txn_id' => $id
            ]);
        }


    }


    public function startRow(): int
    {
        return 2; // Start from the first row (you can change this if you have a header row to skip)
    }

    /**
     * Get the processed tithes data
     */
    public function getTithes(): array
    {
        return $this->tithes;
    }


    public function chunkSize(): int
    {
        return 500; // Process 500 rows per chunk for better memory management
    }
}
