<?php

namespace App\Imports;

use App\Membership;
use App\OfferingType;
use App\PaymentOption;
use App\TitheAndOffering;
use App\TitheOfferingBase;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Maatwebsite\Excel\Concerns\OnEachRow;
use Maatwebsite\Excel\Concerns\ToArray;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Maatwebsite\Excel\Row;
use Throwable;

class CfmsDataImport implements OnEachRow, WithStartRow, ToArray
{
    public $errors;
    private $modeId;
    private TitheOfferingBase $offeringBase;

    public function __construct($modeId, TitheOfferingBase $offeringBase)
    {
        $this->modeId = $modeId;
        $this->errors = collect();
        $this->offeringBase = $offeringBase;
    }

    /**
     * @throws Throwable
     */
    public function onRow(Row $row): void
    {

        $row = $row->toArray(); // Convert row to array

        $type = OfferingType::find($this->modeId);
        $phone = trim($row[5]);
        $phone = strlen($phone) == 12 ? substr($phone, 2) : $phone;

        $company_id = auth()->user()->company_id;
        $member = Membership::query()
            ->where('company_id', $company_id)
            ->where(function (Builder $builder) use ($phone) {
                $builder->where('phone_number', $phone)
                    ->orWhere('phone_number_2', $phone);
            })
            ->first();

        $mId = $member ? $member->id : null;

        $first = PaymentOption::query()
            ->where('CompanyId', '=', $company_id)
            ->where(DB::raw('LOWER(PaymentOption)'), '=', strtolower('CFMS'))->first();
        TitheAndOffering::query()
            ->create([
                'Date' => $row[1],
                'member_names' => $row[2],
                'member_phone' => $phone,
                'OfferingTypeId' => $type->id,
                'Amount' => $row[8],
                'CompanyId' => $company_id,
                'MemberId' => $mId,
                'PaymentOptionId' => $first->id,
                'txn_id' => $row[3],
                'txn_ref' => $row[6],
                'tithe_offering_base_id'=>$this->offeringBase->id
            ]);


    }

    public function startRow(): int
    {
        return 7; // Actual data starts from row 7
    }

    public function array(array $array): array
    {
        return $array;
    }
}
