<?php

namespace App\Http\Controllers;

use App\Model\Menu;
use App\Small_group;
use App\User;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Spatie\Permission\Models\Permission;

class UserController extends Controller
{
    public function index()
    {
        //
        $users = User::query()->where("company_id","=",auth()->user()->company_id)->get();
        $smallGroups = Small_group::query()->where("company_id","=",auth()->user()->company_id)->get();
        return view('users',compact('users','smallGroups'));
    }

    public function permissions(User $user){
        $permissions = Permission::all();
        $selected = $user->permissions()->get()->pluck("id")->toArray();
        return view('permissions',compact('permissions','selected','user'));
    }


    public function addPermissions(Request $request): RedirectResponse
    {

        $user = User::query()->find($request->input("user_id"));
        $user->permissions()->sync($request->input("permissions"));
        return back()->with("success","Permissions added !");

    }

    public function save(Request $request): RedirectResponse
    {
        $id = $request->input("id");

        $message = "User created successfully";
        if($id>0){
            $user = User::find($id);
            $message = "User updated successfully";
        }else{


            $user = new User();
        }

        if($request->input("small_check") == "on"){
            $user->small_group_id = $request->input("small_group_id");
        }

        $user->name = $request->input("name");
        $user->email = $request->input("email");
        $user->company_id = auth()->user()->company_id;
        $user->password = bcrypt($request->input("password"));

        $user->save();

        return back()->with("success",$message);
    }
}
