<?php

namespace App\Http\Controllers;

use App\Small_group;
use Illuminate\Http\Request;

class SmallGroupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     *
     */
    public function index()
    {
        //
        $groups = Small_group::query()->where("company_id","=",auth()->user()->company_id)->orderBy('id','DESC')->get();
        return view('SmallGroup.index',compact('groups'));


    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
        $group = new Small_group();
        $group->group_name = $request->GroupName;
        $group->company_id = auth()->user()->company_id;
        $group->group_leader = $request->GroupLeader;
        $group->leader_phone_number = $request->PhoneNumber;
        $group->description = $request->GroupDesc;
        $group->save();
        return redirect()->back()->with('success','Small Group Added Successfully!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request)
    {
        //
        $group = Small_group::FindorFail($request->input('SmallGroupId'));
        $group->group_name = $request->GroupName;
        $group->company_id = auth()->user()->company_id;
        $group->group_leader = $request->GroupLeader;
        $group->leader_phone_number = $request->PhoneNumber;
        $group->description = $request->GroupDesc;
        $group->save();

        return redirect()->back()->with('success','Small Group Updated Successfully');

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete($id)
    {
        //
        $group = Small_group::find($id);
        $group->delete();
        return redirect()->back()->with('success','Small Group Deleted Successfully');

    }
}
