<?php

namespace App\Http\Controllers;

use App\Exports\TitheOfferingExport;
use App\Exports\TitheOfferingReportExport;
use App\OfferingType;
use App\Services\ReportService;
use App\TitheAndOffering;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Exception;

class ReportsController extends Controller
{
    private ReportService $reportService;

    public function __construct()
    {
        $this->reportService = new ReportService();
    }

    public function titheOfferingReport()
    {
        return view('reports.titheOfferingReport');
    }

    /**
     * @throws Exception
     * @throws \PhpOffice\PhpSpreadsheet\Writer\Exception
     */
    public function exportTitheOfferingReport(Request $request)
    {
        $startDate = $request->input('start_date');
        $endDate = $request->input('end_date');
        $offeringTypeId = $request->input('offering_type_id');


        return \Excel::download(
            new TitheOfferingReportExport($startDate, $endDate, $offeringTypeId),
            "TitheOfferingReport.xlsx"
        );
/*

        $results = $this->reportService->titheOfferingBuilder($startDate, $endDate, $offeringTypeId)
            ->get();

        $offeringType = OfferingType::find($offeringTypeId);

        $pdf = Pdf::loadView('reports.titheOfferingPdf', compact('results', 'startDate', 'endDate', 'offeringType'));
        return $pdf->stream('tithe_offering_report.pdf');*/
    }
}
