<?php

namespace App\Http\Controllers;

use App\ReportDefinition;
use App\ReportSubmission;
use App\ReportSubmissionData;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;

class ReportingDataController extends Controller
{
    public function index(){
        $reportings = ReportSubmission::query()->whereHas('report',function (Builder $builder){
            $builder->where("company_id","=",auth()->user()->company_id);
        })->orderBy('id','DESC')->get();
        $definitions = ReportDefinition::query()->where("company_id","=",auth()->user()->company_id)->get();
        return view('reporting_data.create',compact('reportings','definitions'));
    }

    public function edit(ReportSubmission $submission){
        $submission->load('report');
        return view('reporting_data.modify_report_data',compact('submission'));
    }

    public function submitReport(ReportSubmission $submission){
        $submission->status = "SUBMITTED";
        $submission->save();

        return back()->with('success',"Report Submitted successfully");
    }

    public function submitRecord(ReportSubmission $submission,Request $request){
        $indicatorId = $request->input("indicator_id");
        $value = $request->input("value");

        $obj = ReportSubmissionData::query()->where("indicator_id","=",$indicatorId)
            ->where("submission_id","=",$submission->id)
            ->first();

        if(!$obj){
            $obj = new ReportSubmissionData();
            $obj->submission_id = $submission->id;
            $obj->indicator_id = $indicatorId;
        }

        $obj->indicator_value = $value;
        $obj->save();

        return $obj;
    }

    public function store(Request $request){

        $reporting= new ReportSubmission();
        $reporting->report_id=$request->report_id;
        $reporting->submitted_by=auth()->id();
        $reporting->small_group_id = auth()->user()->small_group_id;
        $reporting->date=$request->date;
        $reporting->month=$request->month;
        $reporting->quarter=$request->quarter;
        $reporting->year=$request->year;
        $reporting->save();

        return redirect()->back()->with('success','Reporting Data Created Successfully');
    }

    public function update(Request $request){

        $reporting= ReportSubmission::findOrFail($request->input('ReportingId'));
        $reporting->report_id=$request->report_id;
        $reporting->submitted_by=auth()->id();
        $reporting->date=$request->date;
        $reporting->month=$request->month;
        $reporting->quarter=$request->quarter;
        $reporting->year=$request->year;
        $reporting->save();
//        dd($request->all());
        return redirect()->back()->with('success','Reporting Data Updated Successfully');
    }

    public function destroy($id){
        DB::beginTransaction();
        $reporting= ReportSubmission::find($id);
        $reporting->data()->delete();
        $reporting->delete();
        DB::commit();
        return redirect()->back()->with('success','Reporting Data Deleted Successfully');
    }
}
