<?php

namespace App\Http\Controllers;

use App\ReportDefinition;
use Illuminate\Http\Request;

class ReportDefinitionController extends Controller
{
    public function index(){
        $reports = ReportDefinition::query()->where("company_id","=",auth()->user()->company_id)->orderBy('id','DESC')->get();
        return view('report_definition.create',compact('reports'));
    }

    public function store(Request $request){

        $report= new ReportDefinition();
        $report->company_id= auth()->user()->company_id;
        $report->report_name=$request->report_name;
        $report->frequency=$request->frequency;
        $report->is_active=true;
        $report->save();
        return redirect()->back()->with('success','Report Definition Created Successfully');
    }

    public function update(Request $request){

        $report= ReportDefinition::findOrFail($request->input('ReportId'));
        $report->report_name=$request->report_name;
        $report->frequency=$request->frequency;
        $report->is_active=$request->is_active;
        $report->save();
        return redirect()->back()->with('success','Report Definition Updated Successfully');
    }

    public function destroy($id){

        $report= ReportDefinition::find($id);
        $report->delete();
        return redirect()->back()->with('success','Report Definition Deleted Successfully');
    }
}
