<?php

namespace App\Http\Controllers;

use App\PaymentOption;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;

class PaymentOptionController extends Controller
{
    public function index()
    {
        $options = PaymentOption::query()->where("CompanyId","=",auth()->user()->company_id)->orderBy('id', 'DESC')->get();
        $company = auth()->user()->company;
        return view('payment_option.create', compact('options','company'));
    }

    public function store(Request $request)
    {

        $option = new PaymentOption();
        $option->CompanyId = auth()->user()->company_id;
        $option->PaymentOption = $request->PaymentOption;
        $option->Is_Active = true;
        $option->save();
        return redirect()->back()->with(['success' => 'Payment Option Created Successfully']);
    }

    public function update(Request $request)
    {

        $option = PaymentOption::FindOrFail($request->input('PaymentOptionId'));
        $option->PaymentOption = $request->PaymentOption;
        $option->Is_Active = $request->Is_Active;
        $option->save();
        return redirect()->back()->with('success', 'Payment Option Updated Successfully');
    }

    public function destroy($id)
    {

        $option = PaymentOption::find($id);
        $option->delete();
        return redirect()->back()->with('success', 'Payment Option Updated Successfully');
    }
}
