<?php

namespace App\Http\Controllers;

use App\OfferingType;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;

class OfferingTypeController extends Controller
{
    public function index()
    {
        $offerings = OfferingType::query()->where("CompanyId","=",auth()->user()->company_id)->orderBy('id', 'DESC')->get();
        $company = auth()->user()->company;
        return view('offering_type.create', compact('offerings','company'));
    }

    public function store(Request $request)
    {

        $offering = new OfferingType();
        $offering->CompanyId = auth()->user()->company_id;
        $offering->OfferingName = $request->OfferingName;
        $offering->Is_Active = true;
        $offering->save();
        return redirect()->back()->with(['success' => 'Offering Type Created Successfully']);
    }

    public function update(Request $request)
    {

        $offering = OfferingType::FindOrFail($request->input('OfferingTypeId'));
        $offering->OfferingName = $request->OfferingName;
        $offering->Is_Active = $request->Is_Active;
        $offering->save();
        return redirect()->back()->with('success', 'Offering Type Updated Successfully');
    }

    public function destroy($id)
    {

        $offering = OfferingType::find($id);
        $offering->delete();
        return redirect()->back()->with('success', 'Offering Type deleted Successfully');
    }
}
