<?php

namespace App\Http\Controllers;

use App\Exports\MembershipExport;
use App\Membership;
use App\TitheAndOffering;
use App\Visit;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Yajra\DataTables\Facades\DataTables;

class MembershipController extends Controller
{


    /**
     * @throws \Exception
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = Membership::query()->with(["companies", "smallgroups", "categories", "statuses"])
                ->where("memberships.company_id", "=", auth()->user()->company_id)
                ->select("memberships.*");
            return Datatables::of($data)
                ->addIndexColumn()
                ->addColumn('action', function ($member) {

                    return $member->id ? ('<div class="btn-group">   <a href="#"
                                                       data-firstname="' . htmlentities($member->firstname) . '"
                                                       data-id="' . $member->id . '"
                                                       data-lastname="' . htmlentities($member->lastname) . '"
                                                       data-phone="' . htmlentities($member->phone_number) . '"
                                                       data-phone_number_2="' . htmlentities($member->phone_number_2) . '"
                                                       data-district="' . $member->district_id . '"
                                                       data-sector="' . $member->sector_id . '"
                                                       data-cell="' . $member->cell_id . '"
                                                       data-village="' . $member->village_id . '"
                                                       data-category="' . $member->category_id . '"
                                                       data-status="' . $member->status_id . '"
                                                       data-small="' . $member->small_group_id . '"
                                                       data-page="' . $member->church_register_page . '"
                                                       data-employment="' . $member->employment_status . '"
                                                       data-marital="' . $member->marital_status . '"
                                                       data-date="' . optional($member->membership_date)->format('Y-m-d') . '"
                                                       class="btn btn-primary btn-edit btn-sm" ><span><i class="far fa-edit"></i>
                                                       </span>
                                                       </a>

                    </div>') : '';

                })
                ->rawColumns(['action'])
                ->make(true);

            // <a href="'.route('Membership.delete',$member->id).'" class="btn btn-danger btn-sm btn-delete" ><span><i class="fas fa-trash"></i></span></a>
        }

        return view('Membership.index', ["company" => auth()->user()->company]);
    }


    public function smMembers()
    {
        //
        $memberdata = Membership::query()
            ->where("company_id", "=", auth()->user()->company_id)
            ->where("small_group_id", "=", auth()->user()->small_group_id)
            ->get();
        return view('Membership.sm_members', ['members' => $memberdata, "company" => auth()->user()->company]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return RedirectResponse
     */
    public function store(Request $request): RedirectResponse
    {
        //

        $id = $request->input("id");

        $message = "Member created successfully";
        if ($id > 0) {
            $message = "Member updated successfully";
            $data = Membership::findOrFail($id);
        } else {
            $data = new Membership();
        }

        $data->firstname = $request->get('member_firstname');
        $data->lastname = $request->get('member_lastname');
        $data->company_id = auth()->user()->company_id;
        $data->phone_number = $request->get('member_phone');
        $data->phone_number_2 = $request->get('phone_number_2');
        $data->district_id = $request->get('member_district');
        $data->sector_id = $request->get('member_sector');
        $data->cell_id = $request->get('member_cell');
        $data->church_register_page = $request->get('church_register_page');
        $data->membership_date = $request->get('membership_date');
        $data->village_id = $request->get('member_village');
        $data->status_id = $request->get('member_status');
        $data->marital_status = $request->get('marital_status');
        $data->employment_status = $request->get('employment_status');
        $data->church_register_page = $request->get('church_register_page');

        if (!$request->input("from_small")) {
            $data->small_group_id = $request->get('member_small_group');
            $data->category_id = $request->get('member_category');
        }

        $data->save();
        // TODO when tithe offering when phone numbers matches but member id is null
        TitheAndOffering::query()
            ->where('member_phone', $data->phone_number)
            ->orWhere('member_phone', $data->phone_number_2)
            ->update(['MemberId' => $data->id]);

        return back()->with("success", $message);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     *
     * @return RedirectResponse
     */
    public function update(Request $request, $id)
    {
        //
        $updates = Membership::find($request->id);

        Membership::where('id', $id)->update([
            'firstname' => $request['member_firstname'],
            'lastname' => $request['member_lastname'],
            'company_id' => $request['member_company'],
            'phone_number' => $request['member_phone'],
            'district_id' => $request['member_district'],
            'sector_id' => $request['member_sector'],
            'cell_id' => $request['member_cell'],
            'village_id' => $request['member_village'],
            'category_id' => $request['member_category'],
            'status_id' => $request['member_status'],
            'church_register_page' => $request['register_page'],
            'small_group_id' => $request['member_small_group']

        ]);

        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     *
     * @return RedirectResponse
     */
    public function destroy($id): RedirectResponse
    {
        //
        $membership = Membership::find($id);
        $membership->delete();

        return back()->with("success", "Member deleted successfully");
    }

    public function exportToExcel()
    {
        return (new MembershipExport())->download('memberships.xlsx');
    }
}
