<?php

namespace App\Http\Controllers;

use App\IndicatorDefinition;
use App\ReportDefinition;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;

class IndicatorDefinitionController extends Controller
{
    public function index(ReportDefinition $definition){
        $indicators = IndicatorDefinition::query()
            ->where("report_id","=",$definition->id)
            ->where("company_id","=",auth()->user()->company_id)->orderBy('id','DESC')->get();

        $definitions = ReportDefinition::query()->where("company_id","=",auth()->user()->company_id)->get();
        return view('indicator_definition.create',compact('indicators','definitions','definition'));
    }

    public function store(Request $request){

        $indicator= new IndicatorDefinition();
        $indicator->report_id=$request->report_id;
        $indicator->company_id= auth()->user()->company_id;
        $indicator->indicator_name=$request->indicator_name;
        $indicator->indicator_value_type=$request->indicator_value_type;
        $indicator->drop_down_data_source=json_encode($request->drop_down_data_source);
        $indicator->save();
        return redirect()->back()->with('success','Indicator Definition Created Successfully');
    }

    public function update(Request $request){

        $indicator= IndicatorDefinition::findOrFail($request->input('IndicatorId'));
        $indicator->report_id=$request->report_id;
        $indicator->indicator_name=$request->indicator_name;
        $indicator->indicator_value_type=$request->indicator_value_type;
        $indicator->drop_down_data_source=json_encode($request->drop_down_data_source);
        $indicator->save();


        return redirect()->back()->with('success','Indicator Definition Updated Successfully');
    }

    public function destroy($id){

        $indicator= IndicatorDefinition::find($id);
        $indicator->delete();
        return redirect()->back()->with('success','Indicator Definition Deleted Successfully');
    }
}
