<?php

namespace App\Http\Controllers;


use App\Cell;
use App\Company;
use App\District;
use App\Http\Controllers\Controller;
use App\Individual;
use App\Sector;
use App\Village;
use App\Visit;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Illuminate\Validation\Rules\In;

class HomeController2 extends Controller
{
    public function districts()
    {
        return District::query()->orderBy("name")->get();
    }

    public function sectors($district_id)
    {
        return Sector::with("district")->where("district_id", "=", $district_id)->orderBy("name")->get();
    }

    public function cells($sector_id)
    {
        return Cell::with(["sector"])->where("sector_id", "=", $sector_id)->orderBy("name")->get();
    }

    public function villages($cell_id)
    {
        return Village::with(["cell"])->where("cell_id", "=", $cell_id)->get();
    }

    public function visits($ind_id)
    {
        return Visit::with(["company", "individual.village.cell.sector.district"])->where("individual_id", "=", $ind_id)->orderByDesc("id")->limit(50)->get();
    }

    public function visitsComp($comp_id)
    {
        return Visit::with(["company", "individual.village.cell.sector.district"])->where("company_id", "=", $comp_id)->orderByDesc("id")->limit(50)->get();
    }

    public function findByPhone($phone)
    {
        $ind = Individual::with(["village.cell.sector.district"])->where("phone", '=', $phone)->first();
        if ($ind != null) {
            return response()->json([
                "names" => $ind->names,
                "village_id" => $ind->village->id ?? 0,
                "cell_id" => $ind->village->cell->id ?? 0,
                "sector_id" => $ind->village->cell->sector->id ?? 0,
                "district_id" => $ind->village->cell->sector->district->id ?? 0,
            ], 200);
        } else
            return response()->json([
                "code" => 0,
                "message" => "Phone number not found"
            ], 500);
    }


    public function saveIndividual(Request $request)
    {
        DB::beginTransaction();
        $ind = new Individual();
        $ind->names = $request->input("names");
        $ind->phone = $request->input("phone");
        $ind->password = $request->input("password");
        $ind->village_id = $request->input("village_id");

        $q = Individual::with(["village.cell.sector.district"]);

        if( $request->has("id") ){
            $q = $q->where("id","=",$request->get("id"));
        }else{
            $q = $q->where("phone", "=", $ind->phone);
        }

        $find = $q->first();

        if ($find != null) {
            $find->update(['password' => $ind->password,'phone' => $ind->phone, "names" => $ind->names, "village_id" => $ind->village_id]);
            DB::commit();
            return $find;
        } else {
            $ind->save();
            $ind->update(['code' => "I" . str_pad($ind->id, 5, "0", STR_PAD_LEFT)]);
            DB::commit();
            return Individual::with(["village.cell.sector.district"])->where("phone", "=", $ind->phone)->first();
        }


    }


    public function saveIndividualWithTemp(Request $request)
    {
        DB::beginTransaction();
        $ind = new Individual();
        $ind->names = $request->input("names");
        $ind->phone = $request->input("phone");
        $ind->village_id = $request->input("village_id");

        $find = Individual::with(["village", "village.cell.sector", "village.cell.sector.district"])->where("phone", "=", $ind->phone)->first();

        $code = "";
        if ($find != null) {
            $code = $find->code;
        } else {
            $ind->save();
            $ind->update(['code' => "I" . str_pad($ind->id, 5, "0", STR_PAD_LEFT)]);
            $code = $ind->code;
        }

        $opt = $this->visitCompany($request, $code, $request->input("company"));

        DB::commit();

        return $opt;
    }


    public function visitCompany(Request $request, $ind, $comp)
    {
        Log::info($comp);

        $cp = Company::where("code", "=", $comp)->first();
        $in = Individual::where("code", "=", $ind)->first();
        if ($cp != null && $in != null) {
            $visit = new Visit();
            Log::info($cp->id);
            $visit->company_id = $cp->id;
            $visit->individual_id = $in->id;
            $visit->temperature = $request->input("temperature");
            $visit->vaccination = $request->input("vaccination");
            $visit->vaccination_code = $request->input("vaccination_code");

            $visit->save();

            $visit->load(["individual", "company"]);

            Log::info($visit);

            return response()->json($visit, 200);
        } else {
            return response()->json([
                "error" => "Not found"
            ], 500);
        }
    }


    public function companyAuthentication(Request $request)
    {


        $find = Company::where("code", "=", $request->input("code"))->where("password", "=", $request->input("password"))->first();

        $find2 = Individual::where("phone", "=", $request->input("code"))->where("password", "=", $request->input("password"))->first();

        if ($find != null) {
            return response()->json([
                "data" => $find,
                "company" => true
            ], 200);
        }

        if ($find2 != null) {
            return response()->json([
                "data" => $find2,
                "company" => false
            ], 200);
        }

        return response()->json([
            "message" => "Company or individual login information not found",
            "code" => 9002
        ], 500);
    }
}
